// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteTargetGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTargetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTargetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteTargetGroupInput"}

	if s.TargetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTargetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTargetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteTargetGroup = "DeleteTargetGroup"

// DeleteTargetGroupRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deletes the specified target group.
//
// You can delete a target group if it is not referenced by any actions. Deleting
// a target group also deletes any associated health checks.
//
//    // Example sending a request using DeleteTargetGroupRequest.
//    req := client.DeleteTargetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup
func (c *Client) DeleteTargetGroupRequest(input *DeleteTargetGroupInput) DeleteTargetGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteTargetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTargetGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteTargetGroupOutput{})

	return DeleteTargetGroupRequest{Request: req, Input: input, Copy: c.DeleteTargetGroupRequest}
}

// DeleteTargetGroupRequest is the request type for the
// DeleteTargetGroup API operation.
type DeleteTargetGroupRequest struct {
	*aws.Request
	Input *DeleteTargetGroupInput
	Copy  func(*DeleteTargetGroupInput) DeleteTargetGroupRequest
}

// Send marshals and sends the DeleteTargetGroup API request.
func (r DeleteTargetGroupRequest) Send(ctx context.Context) (*DeleteTargetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteTargetGroupResponse{
		DeleteTargetGroupOutput: r.Request.Data.(*DeleteTargetGroupOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteTargetGroupResponse is the response type for the
// DeleteTargetGroup API operation.
type DeleteTargetGroupResponse struct {
	*DeleteTargetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteTargetGroup request.
func (r *DeleteTargetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
