// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	LoadBalancerArn *string `type:"string"`

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string `type:"string"`

	// The names of the target groups.
	Names []string `type:"list"`

	// The maximum number of results to return with this call.
	PageSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Names (ARN) of the target groups.
	TargetGroupArns []string `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTargetGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTargetGroupsInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("PageSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTargetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// If there are additional results, this is the marker for the next set of results.
	// Otherwise, this is null.
	NextMarker *string `type:"string"`

	// Information about the target groups.
	TargetGroups []TargetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTargetGroups = "DescribeTargetGroups"

// DescribeTargetGroupsRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Describes the specified target groups or all of your target groups. By default,
// all target groups are described. Alternatively, you can specify one of the
// following to filter the results: the ARN of the load balancer, the names
// of one or more target groups, or the ARNs of one or more target groups.
//
// To describe the targets for a target group, use DescribeTargetHealth. To
// describe the attributes of a target group, use DescribeTargetGroupAttributes.
//
//    // Example sending a request using DescribeTargetGroupsRequest.
//    req := client.DescribeTargetGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups
func (c *Client) DescribeTargetGroupsRequest(input *DescribeTargetGroupsInput) DescribeTargetGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTargetGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeTargetGroupsOutput{})

	return DescribeTargetGroupsRequest{Request: req, Input: input, Copy: c.DescribeTargetGroupsRequest}
}

// DescribeTargetGroupsRequest is the request type for the
// DescribeTargetGroups API operation.
type DescribeTargetGroupsRequest struct {
	*aws.Request
	Input *DescribeTargetGroupsInput
	Copy  func(*DescribeTargetGroupsInput) DescribeTargetGroupsRequest
}

// Send marshals and sends the DescribeTargetGroups API request.
func (r DescribeTargetGroupsRequest) Send(ctx context.Context) (*DescribeTargetGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTargetGroupsResponse{
		DescribeTargetGroupsOutput: r.Request.Data.(*DescribeTargetGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTargetGroupsRequestPaginator returns a paginator for DescribeTargetGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTargetGroupsRequest(input)
//   p := elasticloadbalancingv2.NewDescribeTargetGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTargetGroupsPaginator(req DescribeTargetGroupsRequest) DescribeTargetGroupsPaginator {
	return DescribeTargetGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTargetGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTargetGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTargetGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeTargetGroupsPaginator) CurrentPage() *DescribeTargetGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeTargetGroupsOutput)
}

// DescribeTargetGroupsResponse is the response type for the
// DescribeTargetGroups API operation.
type DescribeTargetGroupsResponse struct {
	*DescribeTargetGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTargetGroups request.
func (r *DescribeTargetGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
