// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyListenerInput struct {
	_ struct{} `type:"structure"`

	// [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN)
	// policy. You can specify one policy name. The following are the possible values:
	//
	//    * HTTP1Only
	//
	//    * HTTP2Only
	//
	//    * HTTP2Optional
	//
	//    * HTTP2Preferred
	//
	//    * None
	//
	// For more information, see ALPN Policies (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies)
	// in the Network Load Balancers Guide.
	AlpnPolicy []string `type:"list"`

	// [HTTPS and TLS listeners] The default certificate for the listener. You must
	// provide exactly one certificate. Set CertificateArn to the certificate ARN
	// but do not set IsDefault.
	//
	// To create a certificate list, use AddListenerCertificates.
	Certificates []Certificate `type:"list"`

	// The actions for the default rule. The rule must include one forward action
	// or one or more fixed-response actions.
	//
	// If the action type is forward, you specify one or more target groups. The
	// protocol of the target group must be HTTP or HTTPS for an Application Load
	// Balancer. The protocol of the target group must be TCP, TLS, UDP, or TCP_UDP
	// for a Network Load Balancer.
	//
	// [HTTPS listeners] If the action type is authenticate-oidc, you authenticate
	// users through an identity provider that is OpenID Connect (OIDC) compliant.
	//
	// [HTTPS listeners] If the action type is authenticate-cognito, you authenticate
	// users through the user pools supported by Amazon Cognito.
	//
	// [Application Load Balancer] If the action type is redirect, you redirect
	// specified client requests from one URL to another.
	//
	// [Application Load Balancer] If the action type is fixed-response, you drop
	// specified client requests and return a custom HTTP response.
	DefaultActions []Action `type:"list"`

	// The Amazon Resource Name (ARN) of the listener.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`

	// The port for connections from clients to the load balancer.
	Port *int64 `min:"1" type:"integer"`

	// The protocol for connections from clients to the load balancer. Application
	// Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers
	// support the TCP, TLS, UDP, and TCP_UDP protocols.
	Protocol ProtocolEnum `type:"string" enum:"true"`

	// [HTTPS and TLS listeners] The security policy that defines which protocols
	// and ciphers are supported. The following are the possible values:
	//
	//    * ELBSecurityPolicy-2016-08
	//
	//    * ELBSecurityPolicy-TLS-1-0-2015-04
	//
	//    * ELBSecurityPolicy-TLS-1-1-2017-01
	//
	//    * ELBSecurityPolicy-TLS-1-2-2017-01
	//
	//    * ELBSecurityPolicy-TLS-1-2-Ext-2018-06
	//
	//    * ELBSecurityPolicy-FS-2018-06
	//
	//    * ELBSecurityPolicy-FS-1-1-2019-08
	//
	//    * ELBSecurityPolicy-FS-1-2-2019-08
	//
	//    * ELBSecurityPolicy-FS-1-2-Res-2019-08
	//
	// For more information, see Security Policies (https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies)
	// in the Application Load Balancers Guide and Security Policies (https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies)
	// in the Network Load Balancers Guide.
	SslPolicy *string `type:"string"`
}

// String returns the string representation
func (s ModifyListenerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyListenerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyListenerInput"}

	if s.ListenerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListenerArn"))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if s.DefaultActions != nil {
		for i, v := range s.DefaultActions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DefaultActions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyListenerOutput struct {
	_ struct{} `type:"structure"`

	// Information about the modified listener.
	Listeners []Listener `type:"list"`
}

// String returns the string representation
func (s ModifyListenerOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyListener = "ModifyListener"

// ModifyListenerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Replaces the specified properties of the specified listener. Any properties
// that you do not specify remain unchanged.
//
// Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the
// security policy and default certificate properties. If you change the protocol
// from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
// and default certificate properties.
//
// To add an item to a list, remove an item from a list, or update an item in
// a list, you must provide the entire list. For example, to add an action,
// specify a list with the current actions plus the new action.
//
//    // Example sending a request using ModifyListenerRequest.
//    req := client.ModifyListenerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener
func (c *Client) ModifyListenerRequest(input *ModifyListenerInput) ModifyListenerRequest {
	op := &aws.Operation{
		Name:       opModifyListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyListenerInput{}
	}

	req := c.newRequest(op, input, &ModifyListenerOutput{})

	return ModifyListenerRequest{Request: req, Input: input, Copy: c.ModifyListenerRequest}
}

// ModifyListenerRequest is the request type for the
// ModifyListener API operation.
type ModifyListenerRequest struct {
	*aws.Request
	Input *ModifyListenerInput
	Copy  func(*ModifyListenerInput) ModifyListenerRequest
}

// Send marshals and sends the ModifyListener API request.
func (r ModifyListenerRequest) Send(ctx context.Context) (*ModifyListenerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyListenerResponse{
		ModifyListenerOutput: r.Request.Data.(*ModifyListenerOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyListenerResponse is the response type for the
// ModifyListener API operation.
type ModifyListenerResponse struct {
	*ModifyListenerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyListener request.
func (r *ModifyListenerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
