// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the DescribeOutboundCrossClusterSearchConnections
// operation.
type DescribeOutboundCrossClusterSearchConnectionsInput struct {
	_ struct{} `type:"structure"`

	// A list of filters used to match properties for outbound cross-cluster search
	// connection. Available Filter names for this operation are:
	//    * cross-cluster-search-connection-id
	//
	//    * destination-domain-info.domain-name
	//
	//    * destination-domain-info.owner-id
	//
	//    * destination-domain-info.region
	//
	//    * source-domain-info.domain-name
	Filters []Filter `type:"list"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `type:"integer"`

	// NextToken is sent in case the earlier API call results contain the NextToken.
	// It is used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeOutboundCrossClusterSearchConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeOutboundCrossClusterSearchConnectionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeOutboundCrossClusterSearchConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOutboundCrossClusterSearchConnectionsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a DescribeOutboundCrossClusterSearchConnections request. Contains
// the list of connections matching the filter criteria.
type DescribeOutboundCrossClusterSearchConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// Consists of list of OutboundCrossClusterSearchConnection matching the specified
	// filter criteria.
	CrossClusterSearchConnections []OutboundCrossClusterSearchConnection `type:"list"`

	// If more results are available and NextToken is present, make the next request
	// to the same API with the received NextToken to paginate the remaining results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeOutboundCrossClusterSearchConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeOutboundCrossClusterSearchConnectionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CrossClusterSearchConnections != nil {
		v := s.CrossClusterSearchConnections

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CrossClusterSearchConnections", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeOutboundCrossClusterSearchConnections = "DescribeOutboundCrossClusterSearchConnections"

// DescribeOutboundCrossClusterSearchConnectionsRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Lists all the outbound cross-cluster search connections for a source domain.
//
//    // Example sending a request using DescribeOutboundCrossClusterSearchConnectionsRequest.
//    req := client.DescribeOutboundCrossClusterSearchConnectionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeOutboundCrossClusterSearchConnectionsRequest(input *DescribeOutboundCrossClusterSearchConnectionsInput) DescribeOutboundCrossClusterSearchConnectionsRequest {
	op := &aws.Operation{
		Name:       opDescribeOutboundCrossClusterSearchConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/ccs/outboundConnection/search",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOutboundCrossClusterSearchConnectionsInput{}
	}

	req := c.newRequest(op, input, &DescribeOutboundCrossClusterSearchConnectionsOutput{})

	return DescribeOutboundCrossClusterSearchConnectionsRequest{Request: req, Input: input, Copy: c.DescribeOutboundCrossClusterSearchConnectionsRequest}
}

// DescribeOutboundCrossClusterSearchConnectionsRequest is the request type for the
// DescribeOutboundCrossClusterSearchConnections API operation.
type DescribeOutboundCrossClusterSearchConnectionsRequest struct {
	*aws.Request
	Input *DescribeOutboundCrossClusterSearchConnectionsInput
	Copy  func(*DescribeOutboundCrossClusterSearchConnectionsInput) DescribeOutboundCrossClusterSearchConnectionsRequest
}

// Send marshals and sends the DescribeOutboundCrossClusterSearchConnections API request.
func (r DescribeOutboundCrossClusterSearchConnectionsRequest) Send(ctx context.Context) (*DescribeOutboundCrossClusterSearchConnectionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeOutboundCrossClusterSearchConnectionsResponse{
		DescribeOutboundCrossClusterSearchConnectionsOutput: r.Request.Data.(*DescribeOutboundCrossClusterSearchConnectionsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeOutboundCrossClusterSearchConnectionsRequestPaginator returns a paginator for DescribeOutboundCrossClusterSearchConnections.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeOutboundCrossClusterSearchConnectionsRequest(input)
//   p := elasticsearchservice.NewDescribeOutboundCrossClusterSearchConnectionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeOutboundCrossClusterSearchConnectionsPaginator(req DescribeOutboundCrossClusterSearchConnectionsRequest) DescribeOutboundCrossClusterSearchConnectionsPaginator {
	return DescribeOutboundCrossClusterSearchConnectionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeOutboundCrossClusterSearchConnectionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeOutboundCrossClusterSearchConnectionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeOutboundCrossClusterSearchConnectionsPaginator struct {
	aws.Pager
}

func (p *DescribeOutboundCrossClusterSearchConnectionsPaginator) CurrentPage() *DescribeOutboundCrossClusterSearchConnectionsOutput {
	return p.Pager.CurrentPage().(*DescribeOutboundCrossClusterSearchConnectionsOutput)
}

// DescribeOutboundCrossClusterSearchConnectionsResponse is the response type for the
// DescribeOutboundCrossClusterSearchConnections API operation.
type DescribeOutboundCrossClusterSearchConnectionsResponse struct {
	*DescribeOutboundCrossClusterSearchConnectionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeOutboundCrossClusterSearchConnections request.
func (r *DescribeOutboundCrossClusterSearchConnectionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
