// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for parameters to DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesInput struct {
	_ struct{} `type:"structure"`

	// Set this value to limit the number of results returned. If not specified,
	// defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The reserved instance identifier filter value. Use this parameter to show
	// only the reservation that matches the specified reserved Elasticsearch instance
	// ID.
	ReservedElasticsearchInstanceId *string `location:"querystring" locationName:"reservationId" type:"string"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeReservedElasticsearchInstancesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReservedElasticsearchInstanceId != nil {
		v := *s.ReservedElasticsearchInstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "reservationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for results from DescribeReservedElasticsearchInstances
type DescribeReservedElasticsearchInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// List of reserved Elasticsearch instances.
	ReservedElasticsearchInstances []ReservedElasticsearchInstance `type:"list"`
}

// String returns the string representation
func (s DescribeReservedElasticsearchInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeReservedElasticsearchInstancesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReservedElasticsearchInstances != nil {
		v := s.ReservedElasticsearchInstances

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ReservedElasticsearchInstances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opDescribeReservedElasticsearchInstances = "DescribeReservedElasticsearchInstances"

// DescribeReservedElasticsearchInstancesRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Returns information about reserved Elasticsearch instances for this account.
//
//    // Example sending a request using DescribeReservedElasticsearchInstancesRequest.
//    req := client.DescribeReservedElasticsearchInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeReservedElasticsearchInstancesRequest(input *DescribeReservedElasticsearchInstancesInput) DescribeReservedElasticsearchInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeReservedElasticsearchInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/reservedInstances",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReservedElasticsearchInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeReservedElasticsearchInstancesOutput{})

	return DescribeReservedElasticsearchInstancesRequest{Request: req, Input: input, Copy: c.DescribeReservedElasticsearchInstancesRequest}
}

// DescribeReservedElasticsearchInstancesRequest is the request type for the
// DescribeReservedElasticsearchInstances API operation.
type DescribeReservedElasticsearchInstancesRequest struct {
	*aws.Request
	Input *DescribeReservedElasticsearchInstancesInput
	Copy  func(*DescribeReservedElasticsearchInstancesInput) DescribeReservedElasticsearchInstancesRequest
}

// Send marshals and sends the DescribeReservedElasticsearchInstances API request.
func (r DescribeReservedElasticsearchInstancesRequest) Send(ctx context.Context) (*DescribeReservedElasticsearchInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReservedElasticsearchInstancesResponse{
		DescribeReservedElasticsearchInstancesOutput: r.Request.Data.(*DescribeReservedElasticsearchInstancesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeReservedElasticsearchInstancesRequestPaginator returns a paginator for DescribeReservedElasticsearchInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeReservedElasticsearchInstancesRequest(input)
//   p := elasticsearchservice.NewDescribeReservedElasticsearchInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeReservedElasticsearchInstancesPaginator(req DescribeReservedElasticsearchInstancesRequest) DescribeReservedElasticsearchInstancesPaginator {
	return DescribeReservedElasticsearchInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeReservedElasticsearchInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeReservedElasticsearchInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeReservedElasticsearchInstancesPaginator struct {
	aws.Pager
}

func (p *DescribeReservedElasticsearchInstancesPaginator) CurrentPage() *DescribeReservedElasticsearchInstancesOutput {
	return p.Pager.CurrentPage().(*DescribeReservedElasticsearchInstancesOutput)
}

// DescribeReservedElasticsearchInstancesResponse is the response type for the
// DescribeReservedElasticsearchInstances API operation.
type DescribeReservedElasticsearchInstancesResponse struct {
	*DescribeReservedElasticsearchInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReservedElasticsearchInstances request.
func (r *DescribeReservedElasticsearchInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
