// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for request parameters to DissociatePackage operation.
type DissociatePackageInput struct {
	_ struct{} `type:"structure"`

	// Name of the domain that you want to associate the package with.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Internal ID of the package that you want to associate with a domain. Use
	// DescribePackages to find this value.
	//
	// PackageID is a required field
	PackageID *string `location:"uri" locationName:"PackageID" type:"string" required:"true"`
}

// String returns the string representation
func (s DissociatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociatePackageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DissociatePackageInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if s.PackageID == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DissociatePackageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageID != nil {
		v := *s.PackageID

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "PackageID", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for response returned by DissociatePackage operation.
type DissociatePackageOutput struct {
	_ struct{} `type:"structure"`

	// DomainPackageDetails
	DomainPackageDetails *DomainPackageDetails `type:"structure"`
}

// String returns the string representation
func (s DissociatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DissociatePackageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainPackageDetails != nil {
		v := s.DomainPackageDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DomainPackageDetails", v, metadata)
	}
	return nil
}

const opDissociatePackage = "DissociatePackage"

// DissociatePackageRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Dissociates a package from the Amazon ES domain.
//
//    // Example sending a request using DissociatePackageRequest.
//    req := client.DissociatePackageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DissociatePackageRequest(input *DissociatePackageInput) DissociatePackageRequest {
	op := &aws.Operation{
		Name:       opDissociatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages/dissociate/{PackageID}/{DomainName}",
	}

	if input == nil {
		input = &DissociatePackageInput{}
	}

	req := c.newRequest(op, input, &DissociatePackageOutput{})

	return DissociatePackageRequest{Request: req, Input: input, Copy: c.DissociatePackageRequest}
}

// DissociatePackageRequest is the request type for the
// DissociatePackage API operation.
type DissociatePackageRequest struct {
	*aws.Request
	Input *DissociatePackageInput
	Copy  func(*DissociatePackageInput) DissociatePackageRequest
}

// Send marshals and sends the DissociatePackage API request.
func (r DissociatePackageRequest) Send(ctx context.Context) (*DissociatePackageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DissociatePackageResponse{
		DissociatePackageOutput: r.Request.Data.(*DissociatePackageOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DissociatePackageResponse is the response type for the
// DissociatePackage API operation.
type DissociatePackageResponse struct {
	*DissociatePackageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DissociatePackage request.
func (r *DissociatePackageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
