// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for request parameters to ListPackagesForDomain operation.
type ListPackagesForDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain for which you want to list associated packages.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Limits results to a maximum number of packages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Used for pagination. Only necessary if a previous API call includes a non-null
	// NextToken value. If provided, returns results for the next page.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPackagesForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPackagesForDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPackagesForDomainInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackagesForDomainInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for response parameters to ListPackagesForDomain operation.
type ListPackagesForDomainOutput struct {
	_ struct{} `type:"structure"`

	// List of DomainPackageDetails objects.
	DomainPackageDetailsList []DomainPackageDetails `type:"list"`

	// Pagination token that needs to be supplied to the next call to get the next
	// page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPackagesForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPackagesForDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DomainPackageDetailsList != nil {
		v := s.DomainPackageDetailsList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "DomainPackageDetailsList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListPackagesForDomain = "ListPackagesForDomain"

// ListPackagesForDomainRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Lists all packages associated with the Amazon ES domain.
//
//    // Example sending a request using ListPackagesForDomainRequest.
//    req := client.ListPackagesForDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListPackagesForDomainRequest(input *ListPackagesForDomainInput) ListPackagesForDomainRequest {
	op := &aws.Operation{
		Name:       opListPackagesForDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain/{DomainName}/packages",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPackagesForDomainInput{}
	}

	req := c.newRequest(op, input, &ListPackagesForDomainOutput{})

	return ListPackagesForDomainRequest{Request: req, Input: input, Copy: c.ListPackagesForDomainRequest}
}

// ListPackagesForDomainRequest is the request type for the
// ListPackagesForDomain API operation.
type ListPackagesForDomainRequest struct {
	*aws.Request
	Input *ListPackagesForDomainInput
	Copy  func(*ListPackagesForDomainInput) ListPackagesForDomainRequest
}

// Send marshals and sends the ListPackagesForDomain API request.
func (r ListPackagesForDomainRequest) Send(ctx context.Context) (*ListPackagesForDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPackagesForDomainResponse{
		ListPackagesForDomainOutput: r.Request.Data.(*ListPackagesForDomainOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPackagesForDomainRequestPaginator returns a paginator for ListPackagesForDomain.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPackagesForDomainRequest(input)
//   p := elasticsearchservice.NewListPackagesForDomainRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPackagesForDomainPaginator(req ListPackagesForDomainRequest) ListPackagesForDomainPaginator {
	return ListPackagesForDomainPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPackagesForDomainInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPackagesForDomainPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPackagesForDomainPaginator struct {
	aws.Pager
}

func (p *ListPackagesForDomainPaginator) CurrentPage() *ListPackagesForDomainOutput {
	return p.Pager.CurrentPage().(*ListPackagesForDomainOutput)
}

// ListPackagesForDomainResponse is the response type for the
// ListPackagesForDomain API operation.
type ListPackagesForDomainResponse struct {
	*ListPackagesForDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPackagesForDomain request.
func (r *ListPackagesForDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
