// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the RejectInboundCrossClusterSearchConnection
// operation.
type RejectInboundCrossClusterSearchConnectionInput struct {
	_ struct{} `type:"structure"`

	// The id of the inbound connection that you want to reject.
	//
	// CrossClusterSearchConnectionId is a required field
	CrossClusterSearchConnectionId *string `location:"uri" locationName:"ConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s RejectInboundCrossClusterSearchConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectInboundCrossClusterSearchConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RejectInboundCrossClusterSearchConnectionInput"}

	if s.CrossClusterSearchConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrossClusterSearchConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RejectInboundCrossClusterSearchConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CrossClusterSearchConnectionId != nil {
		v := *s.CrossClusterSearchConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a RejectInboundCrossClusterSearchConnection operation. Contains
// details of rejected inbound connection.
type RejectInboundCrossClusterSearchConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the InboundCrossClusterSearchConnection of rejected inbound connection.
	CrossClusterSearchConnection *InboundCrossClusterSearchConnection `type:"structure"`
}

// String returns the string representation
func (s RejectInboundCrossClusterSearchConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RejectInboundCrossClusterSearchConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CrossClusterSearchConnection != nil {
		v := s.CrossClusterSearchConnection

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CrossClusterSearchConnection", v, metadata)
	}
	return nil
}

const opRejectInboundCrossClusterSearchConnection = "RejectInboundCrossClusterSearchConnection"

// RejectInboundCrossClusterSearchConnectionRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Allows the destination domain owner to reject an inbound cross-cluster search
// connection request.
//
//    // Example sending a request using RejectInboundCrossClusterSearchConnectionRequest.
//    req := client.RejectInboundCrossClusterSearchConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) RejectInboundCrossClusterSearchConnectionRequest(input *RejectInboundCrossClusterSearchConnectionInput) RejectInboundCrossClusterSearchConnectionRequest {
	op := &aws.Operation{
		Name:       opRejectInboundCrossClusterSearchConnection,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/reject",
	}

	if input == nil {
		input = &RejectInboundCrossClusterSearchConnectionInput{}
	}

	req := c.newRequest(op, input, &RejectInboundCrossClusterSearchConnectionOutput{})

	return RejectInboundCrossClusterSearchConnectionRequest{Request: req, Input: input, Copy: c.RejectInboundCrossClusterSearchConnectionRequest}
}

// RejectInboundCrossClusterSearchConnectionRequest is the request type for the
// RejectInboundCrossClusterSearchConnection API operation.
type RejectInboundCrossClusterSearchConnectionRequest struct {
	*aws.Request
	Input *RejectInboundCrossClusterSearchConnectionInput
	Copy  func(*RejectInboundCrossClusterSearchConnectionInput) RejectInboundCrossClusterSearchConnectionRequest
}

// Send marshals and sends the RejectInboundCrossClusterSearchConnection API request.
func (r RejectInboundCrossClusterSearchConnectionRequest) Send(ctx context.Context) (*RejectInboundCrossClusterSearchConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RejectInboundCrossClusterSearchConnectionResponse{
		RejectInboundCrossClusterSearchConnectionOutput: r.Request.Data.(*RejectInboundCrossClusterSearchConnectionOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RejectInboundCrossClusterSearchConnectionResponse is the response type for the
// RejectInboundCrossClusterSearchConnection API operation.
type RejectInboundCrossClusterSearchConnectionResponse struct {
	*RejectInboundCrossClusterSearchConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RejectInboundCrossClusterSearchConnection request.
func (r *RejectInboundCrossClusterSearchConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
