// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for the parameters to the StartElasticsearchServiceSoftwareUpdate
// operation. Specifies the name of the Elasticsearch domain that you wish to
// schedule a service software update on.
type StartElasticsearchServiceSoftwareUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that you want to update to the latest service software.
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartElasticsearchServiceSoftwareUpdateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartElasticsearchServiceSoftwareUpdateInput"}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartElasticsearchServiceSoftwareUpdateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The result of a StartElasticsearchServiceSoftwareUpdate operation. Contains
// the status of the update.
type StartElasticsearchServiceSoftwareUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch service software update.
	ServiceSoftwareOptions *ServiceSoftwareOptions `type:"structure"`
}

// String returns the string representation
func (s StartElasticsearchServiceSoftwareUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartElasticsearchServiceSoftwareUpdateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ServiceSoftwareOptions != nil {
		v := s.ServiceSoftwareOptions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ServiceSoftwareOptions", v, metadata)
	}
	return nil
}

const opStartElasticsearchServiceSoftwareUpdate = "StartElasticsearchServiceSoftwareUpdate"

// StartElasticsearchServiceSoftwareUpdateRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Schedules a service software update for an Amazon ES domain.
//
//    // Example sending a request using StartElasticsearchServiceSoftwareUpdateRequest.
//    req := client.StartElasticsearchServiceSoftwareUpdateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartElasticsearchServiceSoftwareUpdateRequest(input *StartElasticsearchServiceSoftwareUpdateInput) StartElasticsearchServiceSoftwareUpdateRequest {
	op := &aws.Operation{
		Name:       opStartElasticsearchServiceSoftwareUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/serviceSoftwareUpdate/start",
	}

	if input == nil {
		input = &StartElasticsearchServiceSoftwareUpdateInput{}
	}

	req := c.newRequest(op, input, &StartElasticsearchServiceSoftwareUpdateOutput{})

	return StartElasticsearchServiceSoftwareUpdateRequest{Request: req, Input: input, Copy: c.StartElasticsearchServiceSoftwareUpdateRequest}
}

// StartElasticsearchServiceSoftwareUpdateRequest is the request type for the
// StartElasticsearchServiceSoftwareUpdate API operation.
type StartElasticsearchServiceSoftwareUpdateRequest struct {
	*aws.Request
	Input *StartElasticsearchServiceSoftwareUpdateInput
	Copy  func(*StartElasticsearchServiceSoftwareUpdateInput) StartElasticsearchServiceSoftwareUpdateRequest
}

// Send marshals and sends the StartElasticsearchServiceSoftwareUpdate API request.
func (r StartElasticsearchServiceSoftwareUpdateRequest) Send(ctx context.Context) (*StartElasticsearchServiceSoftwareUpdateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartElasticsearchServiceSoftwareUpdateResponse{
		StartElasticsearchServiceSoftwareUpdateOutput: r.Request.Data.(*StartElasticsearchServiceSoftwareUpdateOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartElasticsearchServiceSoftwareUpdateResponse is the response type for the
// StartElasticsearchServiceSoftwareUpdate API operation.
type StartElasticsearchServiceSoftwareUpdateResponse struct {
	*StartElasticsearchServiceSoftwareUpdateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartElasticsearchServiceSoftwareUpdate request.
func (r *StartElasticsearchServiceSoftwareUpdateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
