// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The ListPipelineRequest structure.
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// To list pipelines in chronological order by the date and time that they were
	// created, enter true. To list pipelines in reverse chronological order, enter
	// false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPipelinesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Ascending != nil {
		v := *s.Ascending

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Ascending", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageToken != nil {
		v := *s.PageToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "PageToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of the pipelines associated with the current AWS account.
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the pipelines fit on one page or when you've reached the last
	// page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`

	// An array of Pipeline objects.
	Pipelines []Pipeline `type:"list"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPipelinesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextPageToken != nil {
		v := *s.NextPageToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextPageToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Pipelines != nil {
		v := s.Pipelines

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Pipelines", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The ListPipelines operation gets a list of the pipelines associated with
// the current AWS account.
//
//    // Example sending a request using ListPipelinesRequest.
//    req := client.ListPipelinesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListPipelinesRequest(input *ListPipelinesInput) ListPipelinesRequest {
	op := &aws.Operation{
		Name:       opListPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/pipelines",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	req := c.newRequest(op, input, &ListPipelinesOutput{})

	return ListPipelinesRequest{Request: req, Input: input, Copy: c.ListPipelinesRequest}
}

// ListPipelinesRequest is the request type for the
// ListPipelines API operation.
type ListPipelinesRequest struct {
	*aws.Request
	Input *ListPipelinesInput
	Copy  func(*ListPipelinesInput) ListPipelinesRequest
}

// Send marshals and sends the ListPipelines API request.
func (r ListPipelinesRequest) Send(ctx context.Context) (*ListPipelinesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPipelinesResponse{
		ListPipelinesOutput: r.Request.Data.(*ListPipelinesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPipelinesRequestPaginator returns a paginator for ListPipelines.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPipelinesRequest(input)
//   p := elastictranscoder.NewListPipelinesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPipelinesPaginator(req ListPipelinesRequest) ListPipelinesPaginator {
	return ListPipelinesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPipelinesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPipelinesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPipelinesPaginator struct {
	aws.Pager
}

func (p *ListPipelinesPaginator) CurrentPage() *ListPipelinesOutput {
	return p.Pager.CurrentPage().(*ListPipelinesOutput)
}

// ListPipelinesResponse is the response type for the
// ListPipelines API operation.
type ListPipelinesResponse struct {
	*ListPipelinesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPipelines request.
func (r *ListPipelinesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
