// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The ReadJobRequest structure.
type ReadJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job for which you want to get detailed information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ReadJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReadJobInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReadJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The ReadJobResponse structure.
type ReadJobOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the job.
	Job *Job `type:"structure"`
}

// String returns the string representation
func (s ReadJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReadJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Job != nil {
		v := s.Job

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Job", v, metadata)
	}
	return nil
}

const opReadJob = "ReadJob"

// ReadJobRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The ReadJob operation returns detailed information about a job.
//
//    // Example sending a request using ReadJobRequest.
//    req := client.ReadJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ReadJobRequest(input *ReadJobInput) ReadJobRequest {
	op := &aws.Operation{
		Name:       opReadJob,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/jobs/{Id}",
	}

	if input == nil {
		input = &ReadJobInput{}
	}

	req := c.newRequest(op, input, &ReadJobOutput{})

	return ReadJobRequest{Request: req, Input: input, Copy: c.ReadJobRequest}
}

// ReadJobRequest is the request type for the
// ReadJob API operation.
type ReadJobRequest struct {
	*aws.Request
	Input *ReadJobInput
	Copy  func(*ReadJobInput) ReadJobRequest
}

// Send marshals and sends the ReadJob API request.
func (r ReadJobRequest) Send(ctx context.Context) (*ReadJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReadJobResponse{
		ReadJobOutput: r.Request.Data.(*ReadJobOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReadJobResponse is the response type for the
// ReadJob API operation.
type ReadJobResponse struct {
	*ReadJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReadJob request.
func (r *ReadJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
