// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The input for the DescribeJobFlows operation.
type DescribeJobFlowsInput struct {
	_ struct{} `type:"structure"`

	// Return only job flows created after this date and time.
	CreatedAfter *time.Time `type:"timestamp"`

	// Return only job flows created before this date and time.
	CreatedBefore *time.Time `type:"timestamp"`

	// Return only job flows whose job flow ID is contained in this list.
	JobFlowIds []string `type:"list"`

	// Return only job flows whose state is contained in this list.
	JobFlowStates []JobFlowExecutionState `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// The output for the DescribeJobFlows operation.
type DescribeJobFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job flows matching the parameters supplied.
	JobFlows []JobFlowDetail `type:"list"`
}

// String returns the string representation
func (s DescribeJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeJobFlows = "DescribeJobFlows"

// DescribeJobFlowsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// This API is deprecated and will eventually be removed. We recommend you use
// ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions
// instead.
//
// DescribeJobFlows returns a list of job flows that match all of the supplied
// parameters. The parameters can include a list of job flow IDs, job flow states,
// and restrictions on job flow creation date and time.
//
// Regardless of supplied parameters, only job flows created within the last
// two months are returned.
//
// If no parameters are supplied, then job flows matching either of the following
// criteria are returned:
//
//    * Job flows created and completed in the last two weeks
//
//    * Job flows created within the last two months that are in one of the
//    following states: RUNNING, WAITING, SHUTTING_DOWN, STARTING
//
// Amazon EMR can return a maximum of 512 job flow descriptions.
//
//    // Example sending a request using DescribeJobFlowsRequest.
//    req := client.DescribeJobFlowsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/DescribeJobFlows
func (c *Client) DescribeJobFlowsRequest(input *DescribeJobFlowsInput) DescribeJobFlowsRequest {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeJobFlows, has been deprecated")
	}
	op := &aws.Operation{
		Name:       opDescribeJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobFlowsInput{}
	}

	req := c.newRequest(op, input, &DescribeJobFlowsOutput{})

	return DescribeJobFlowsRequest{Request: req, Input: input, Copy: c.DescribeJobFlowsRequest}
}

// DescribeJobFlowsRequest is the request type for the
// DescribeJobFlows API operation.
type DescribeJobFlowsRequest struct {
	*aws.Request
	Input *DescribeJobFlowsInput
	Copy  func(*DescribeJobFlowsInput) DescribeJobFlowsRequest
}

// Send marshals and sends the DescribeJobFlows API request.
func (r DescribeJobFlowsRequest) Send(ctx context.Context) (*DescribeJobFlowsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeJobFlowsResponse{
		DescribeJobFlowsOutput: r.Request.Data.(*DescribeJobFlowsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeJobFlowsResponse is the response type for the
// DescribeJobFlows API operation.
type DescribeJobFlowsResponse struct {
	*DescribeJobFlowsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeJobFlows request.
func (r *DescribeJobFlowsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
