// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// This input determines which instances to list.
type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the cluster for which to list the instances.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The unique identifier of the instance fleet.
	InstanceFleetId *string `type:"string"`

	// The node type of the instance fleet. For example MASTER, CORE, or TASK.
	InstanceFleetType InstanceFleetType `type:"string" enum:"true"`

	// The identifier of the instance group for which to list the instances.
	InstanceGroupId *string `type:"string"`

	// The type of instance group for which to list the instances.
	InstanceGroupTypes []InstanceGroupType `type:"list"`

	// A list of instance states that will filter the instances returned with this
	// request.
	InstanceStates []InstanceState `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInstancesInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This output contains the list of instances.
type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of instances for the cluster and given filters.
	Instances []Instance `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListInstances = "ListInstances"

// ListInstancesRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Provides information for all active EC2 instances and EC2 instances terminated
// in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the
// following states are considered active: AWAITING_FULFILLMENT, PROVISIONING,
// BOOTSTRAPPING, RUNNING.
//
//    // Example sending a request using ListInstancesRequest.
//    req := client.ListInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstances
func (c *Client) ListInstancesRequest(input *ListInstancesInput) ListInstancesRequest {
	op := &aws.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	req := c.newRequest(op, input, &ListInstancesOutput{})

	return ListInstancesRequest{Request: req, Input: input, Copy: c.ListInstancesRequest}
}

// ListInstancesRequest is the request type for the
// ListInstances API operation.
type ListInstancesRequest struct {
	*aws.Request
	Input *ListInstancesInput
	Copy  func(*ListInstancesInput) ListInstancesRequest
}

// Send marshals and sends the ListInstances API request.
func (r ListInstancesRequest) Send(ctx context.Context) (*ListInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInstancesResponse{
		ListInstancesOutput: r.Request.Data.(*ListInstancesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInstancesRequestPaginator returns a paginator for ListInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInstancesRequest(input)
//   p := emr.NewListInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInstancesPaginator(req ListInstancesRequest) ListInstancesPaginator {
	return ListInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInstancesPaginator struct {
	aws.Pager
}

func (p *ListInstancesPaginator) CurrentPage() *ListInstancesOutput {
	return p.Pager.CurrentPage().(*ListInstancesOutput)
}

// ListInstancesResponse is the response type for the
// ListInstances API operation.
type ListInstancesResponse struct {
	*ListInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInstances request.
func (r *ListInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
