// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// With Amazon EMR release version 4.0 and later, the only accepted parameter
// is the application name. To pass arguments to applications, you use configuration
// classifications specified using configuration JSON objects. For more information,
// see Configuring Applications (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
//
// With earlier Amazon EMR releases, the application is any Amazon or third-party
// software that you can add to the cluster. This structure contains a list
// of strings that indicates the software to use with the cluster and accepts
// a user argument list. Amazon EMR accepts and forwards the argument list to
// the corresponding installation script as bootstrap action argument.
type Application struct {
	_ struct{} `type:"structure"`

	// This option is for advanced users only. This is meta information about third-party
	// applications that third-party vendors use for testing purposes.
	AdditionalInfo map[string]string `type:"map"`

	// Arguments for Amazon EMR to pass to the application.
	Args []string `type:"list"`

	// The name of the application.
	Name *string `type:"string"`

	// The version of the application.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// An automatic scaling policy for a core instance group or task instance group
// in an Amazon EMR cluster. An automatic scaling policy defines how an instance
// group dynamically adds and terminates EC2 instances in response to the value
// of a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The upper and lower EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above
	// or below these limits.
	//
	// Constraints is a required field
	Constraints *ScalingConstraints `type:"structure" required:"true"`

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	//
	// Rules is a required field
	Rules []ScalingRule `type:"list" required:"true"`
}

// String returns the string representation
func (s AutoScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoScalingPolicy"}

	if s.Constraints == nil {
		invalidParams.Add(aws.NewErrParamRequired("Constraints"))
	}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Constraints != nil {
		if err := s.Constraints.Validate(); err != nil {
			invalidParams.AddNested("Constraints", err.(aws.ErrInvalidParams))
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An automatic scaling policy for a core instance group or task instance group
// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
// group dynamically adds and terminates EC2 instances in response to the value
// of a CloudWatch metric. See PutAutoScalingPolicy.
type AutoScalingPolicyDescription struct {
	_ struct{} `type:"structure"`

	// The upper and lower EC2 instance limits for an automatic scaling policy.
	// Automatic scaling activity will not cause an instance group to grow above
	// or below these limits.
	Constraints *ScalingConstraints `type:"structure"`

	// The scale-in and scale-out rules that comprise the automatic scaling policy.
	Rules []ScalingRule `type:"list"`

	// The status of an automatic scaling policy.
	Status *AutoScalingPolicyStatus `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyDescription) String() string {
	return awsutil.Prettify(s)
}

// The reason for an AutoScalingPolicyStatus change.
type AutoScalingPolicyStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The code indicating the reason for the change in status.USER_REQUEST indicates
	// that the scaling policy status was changed by a user. PROVISION_FAILURE indicates
	// that the status change was because the policy failed to provision. CLEANUP_FAILURE
	// indicates an error.
	Code AutoScalingPolicyStateChangeReasonCode `type:"string" enum:"true"`

	// A friendly, more verbose message that accompanies an automatic scaling policy
	// state change.
	Message *string `type:"string"`
}

// String returns the string representation
func (s AutoScalingPolicyStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The status of an automatic scaling policy.
type AutoScalingPolicyStatus struct {
	_ struct{} `type:"structure"`

	// Indicates the status of the automatic scaling policy.
	State AutoScalingPolicyState `type:"string" enum:"true"`

	// The reason for a change in status.
	StateChangeReason *AutoScalingPolicyStateChangeReason `type:"structure"`
}

// String returns the string representation
func (s AutoScalingPolicyStatus) String() string {
	return awsutil.Prettify(s)
}

// A configuration for Amazon EMR block public access. When BlockPublicSecurityGroupRules
// is set to true, Amazon EMR prevents cluster creation if one of the cluster's
// security groups has a rule that allows inbound traffic from 0.0.0.0/0 or
// ::/0 on a port, unless the port is specified as an exception using PermittedPublicSecurityGroupRuleRanges.
type BlockPublicAccessConfiguration struct {
	_ struct{} `type:"structure"`

	// Indicates whether EMR block public access is enabled (true) or disabled (false).
	// By default, the value is false for accounts that have created EMR clusters
	// before July 2019. For accounts created after this, the default is true.
	//
	// BlockPublicSecurityGroupRules is a required field
	BlockPublicSecurityGroupRules *bool `type:"boolean" required:"true"`

	// Specifies ports and port ranges that are permitted to have security group
	// rules that allow inbound traffic from all public sources. For example, if
	// Port 23 (Telnet) is specified for PermittedPublicSecurityGroupRuleRanges,
	// Amazon EMR allows cluster creation if a security group associated with the
	// cluster has a rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0
	// or IPv6 port ::/0 as the source.
	//
	// By default, Port 22, which is used for SSH access to the cluster EC2 instances,
	// is in the list of PermittedPublicSecurityGroupRuleRanges.
	PermittedPublicSecurityGroupRuleRanges []PortRange `type:"list"`
}

// String returns the string representation
func (s BlockPublicAccessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockPublicAccessConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BlockPublicAccessConfiguration"}

	if s.BlockPublicSecurityGroupRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("BlockPublicSecurityGroupRules"))
	}
	if s.PermittedPublicSecurityGroupRuleRanges != nil {
		for i, v := range s.PermittedPublicSecurityGroupRuleRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PermittedPublicSecurityGroupRuleRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Properties that describe the AWS principal that created the BlockPublicAccessConfiguration
// using the PutBlockPublicAccessConfiguration action as well as the date and
// time that the configuration was created. Each time a configuration for block
// public access is updated, Amazon EMR updates this metadata.
type BlockPublicAccessConfigurationMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name that created or last modified the configuration.
	//
	// CreatedByArn is a required field
	CreatedByArn *string `min:"20" type:"string" required:"true"`

	// The date and time that the configuration was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s BlockPublicAccessConfigurationMetadata) String() string {
	return awsutil.Prettify(s)
}

// Configuration of a bootstrap action.
type BootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	// The name of the bootstrap action.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The script run by the bootstrap action.
	//
	// ScriptBootstrapAction is a required field
	ScriptBootstrapAction *ScriptBootstrapActionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s BootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BootstrapActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BootstrapActionConfig"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.ScriptBootstrapAction == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScriptBootstrapAction"))
	}
	if s.ScriptBootstrapAction != nil {
		if err := s.ScriptBootstrapAction.Validate(); err != nil {
			invalidParams.AddNested("ScriptBootstrapAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Reports the configuration of a bootstrap action in a cluster (job flow).
type BootstrapActionDetail struct {
	_ struct{} `type:"structure"`

	// A description of the bootstrap action.
	BootstrapActionConfig *BootstrapActionConfig `type:"structure"`
}

// String returns the string representation
func (s BootstrapActionDetail) String() string {
	return awsutil.Prettify(s)
}

// Specification of the status of a CancelSteps request. Available only in Amazon
// EMR version 4.8.0 and later, excluding version 5.0.0.
type CancelStepsInfo struct {
	_ struct{} `type:"structure"`

	// The reason for the failure if the CancelSteps request fails.
	Reason *string `type:"string"`

	// The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.
	Status CancelStepsRequestStatus `type:"string" enum:"true"`

	// The encrypted StepId of a step.
	StepId *string `type:"string"`
}

// String returns the string representation
func (s CancelStepsInfo) String() string {
	return awsutil.Prettify(s)
}

// The definition of a CloudWatch metric alarm, which determines when an automatic
// scaling activity is triggered. When the defined alarm conditions are satisfied,
// scaling activity begins.
type CloudWatchAlarmDefinition struct {
	_ struct{} `type:"structure"`

	// Determines how the metric specified by MetricName is compared to the value
	// specified by Threshold.
	//
	// ComparisonOperator is a required field
	ComparisonOperator ComparisonOperator `type:"string" required:"true" enum:"true"`

	// A CloudWatch metric dimension.
	Dimensions []MetricDimension `type:"list"`

	// The number of periods, in five-minute increments, during which the alarm
	// condition must exist before the alarm triggers automatic scaling activity.
	// The default value is 1.
	EvaluationPeriods *int64 `type:"integer"`

	// The name of the CloudWatch metric that is watched to determine an alarm condition.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// The namespace for the CloudWatch metric. The default is AWS/ElasticMapReduce.
	Namespace *string `type:"string"`

	// The period, in seconds, over which the statistic is applied. EMR CloudWatch
	// metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch
	// metric is specified, specify 300.
	//
	// Period is a required field
	Period *int64 `type:"integer" required:"true"`

	// The statistic to apply to the metric associated with the alarm. The default
	// is AVERAGE.
	Statistic Statistic `type:"string" enum:"true"`

	// The value against which the specified statistic is compared.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`

	// The unit of measure associated with the CloudWatch metric being watched.
	// The value specified for Unit must correspond to the units specified in the
	// CloudWatch metric.
	Unit Unit `type:"string" enum:"true"`
}

// String returns the string representation
func (s CloudWatchAlarmDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchAlarmDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchAlarmDefinition"}
	if len(s.ComparisonOperator) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComparisonOperator"))
	}

	if s.MetricName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricName"))
	}

	if s.Period == nil {
		invalidParams.Add(aws.NewErrParamRequired("Period"))
	}

	if s.Threshold == nil {
		invalidParams.Add(aws.NewErrParamRequired("Threshold"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The detailed description of the cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The applications installed on this cluster.
	Applications []Application `type:"list"`

	// An IAM role for automatic scaling policies. The default role is EMR_AutoScaling_DefaultRole.
	// The IAM role provides permissions that the automatic scaling feature requires
	// to launch and terminate EC2 instances in an instance group.
	AutoScalingRole *string `type:"string"`

	// Specifies whether the cluster should terminate after completing all steps.
	AutoTerminate *bool `type:"boolean"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// Applies only to Amazon EMR releases 4.x and later. The list of Configurations
	// supplied to the EMR cluster.
	Configurations []Configuration `type:"list"`

	// Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
	// Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.
	CustomAmiId *string `type:"string"`

	// The size, in GiB, of the EBS root device volume of the Linux AMI that is
	// used for each EC2 instance. Available in Amazon EMR version 4.x and later.
	EbsRootVolumeSize *int64 `type:"integer"`

	// Provides information about the EC2 instances in a cluster grouped by category.
	// For example, key name, subnet ID, IAM instance profile, and so on.
	Ec2InstanceAttributes *Ec2InstanceAttributes `type:"structure"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	//
	// The instance group configuration of the cluster. A value of INSTANCE_GROUP
	// indicates a uniform instance group configuration. A value of INSTANCE_FLEET
	// indicates an instance fleets configuration.
	InstanceCollectionType InstanceCollectionType `type:"string" enum:"true"`

	// Attributes for Kerberos configuration when Kerberos authentication is enabled
	// using a security configuration. For more information see Use Kerberos Authentication
	// (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
	// in the EMR Management Guide.
	KerberosAttributes *KerberosAttributes `type:"structure"`

	// The AWS KMS customer master key (CMK) used for encrypting log files. This
	// attribute is only available with EMR version 5.30.0 and later, excluding
	// EMR 6.0.0.
	LogEncryptionKmsKeyId *string `type:"string"`

	// The path to the Amazon S3 location where logs for this cluster are stored.
	LogUri *string `type:"string"`

	// The DNS name of the master node. If the cluster is on a private subnet, this
	// is the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string `type:"string"`

	// The Amazon EMR release label, which determines the version of open-source
	// application packages installed on the cluster. Release labels are in the
	// form emr-x.x.x, where x.x.x is an Amazon EMR release version such as emr-5.14.0.
	// For more information about Amazon EMR release versions and included application
	// versions and features, see https://docs.aws.amazon.com/emr/latest/ReleaseGuide/
	// (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/). The release label
	// applies only to Amazon EMR releases version 4.0 and later. Earlier versions
	// use AmiVersion.
	ReleaseLabel *string `type:"string"`

	// Applies only when CustomAmiID is used. Specifies the type of updates that
	// are applied from the Amazon Linux AMI package repositories when an instance
	// boots using the AMI.
	RepoUpgradeOnBoot RepoUpgradeOnBoot `type:"string" enum:"true"`

	// The AMI version requested for this cluster.
	RequestedAmiVersion *string `type:"string"`

	// The AMI version running on this cluster.
	RunningAmiVersion *string `type:"string"`

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
	// indicates that Amazon EMR terminates nodes at the instance-hour boundary,
	// regardless of when the request to terminate the instance was submitted. This
	// option is only available with Amazon EMR 5.1.0 and later and is the default
	// for clusters created using that version. TERMINATE_AT_TASK_COMPLETION indicates
	// that Amazon EMR blacklists and drains tasks from nodes before terminating
	// the Amazon EC2 instances, regardless of the instance-hour boundary. With
	// either behavior, Amazon EMR removes the least active nodes first and blocks
	// instance termination if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION
	// is available only in Amazon EMR version 4.1.0 and later, and is the default
	// for versions of Amazon EMR earlier than 5.1.0.
	ScaleDownBehavior ScaleDownBehavior `type:"string" enum:"true"`

	// The name of the security configuration applied to the cluster.
	SecurityConfiguration *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// The current status details about the cluster.
	Status *ClusterStatus `type:"structure"`

	// Specifies the number of steps that can be executed concurrently.
	StepConcurrencyLevel *int64 `type:"integer"`

	// A list of tags associated with a cluster.
	Tags []Tag `type:"list"`

	// Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances
	// from being terminated by an API call or user intervention, or in the event
	// of a cluster error.
	TerminationProtected *bool `type:"boolean"`

	// Indicates whether the cluster is visible to all IAM users of the AWS account
	// associated with the cluster. The default value, true, indicates that all
	// IAM users in the AWS account can perform cluster actions if they have the
	// proper IAM policy permissions. If this value is false, only the IAM user
	// that created the cluster can perform actions. This value can be changed on
	// a running cluster by using the SetVisibleToAllUsers action. You can override
	// the default value of true when you create a cluster by using the VisibleToAllUsers
	// parameter of the RunJobFlow action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// The reason that the cluster changed to its current state.
type ClusterStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmatic code for the state change reason.
	Code ClusterStateChangeReasonCode `type:"string" enum:"true"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s ClusterStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The detailed status of the cluster.
type ClusterStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the cluster.
	State ClusterState `type:"string" enum:"true"`

	// The reason for the cluster status change.
	StateChangeReason *ClusterStateChangeReason `type:"structure"`

	// A timeline that represents the status of a cluster over the lifetime of the
	// cluster.
	Timeline *ClusterTimeline `type:"structure"`
}

// String returns the string representation
func (s ClusterStatus) String() string {
	return awsutil.Prettify(s)
}

// The summary description of the cluster.
type ClusterSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of the cluster.
	ClusterArn *string `min:"20" type:"string"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
	OutpostArn *string `type:"string"`

	// The details about the current status of the cluster.
	Status *ClusterStatus `type:"structure"`
}

// String returns the string representation
func (s ClusterSummary) String() string {
	return awsutil.Prettify(s)
}

// Represents the timeline of the cluster's lifecycle.
type ClusterTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the cluster.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster was ready to execute steps.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ClusterTimeline) String() string {
	return awsutil.Prettify(s)
}

// An entity describing an executable that runs on a cluster.
type Command struct {
	_ struct{} `type:"structure"`

	// Arguments for Amazon EMR to pass to the command for execution.
	Args []string `type:"list"`

	// The name of the command.
	Name *string `type:"string"`

	// The Amazon S3 location of the command script.
	ScriptPath *string `type:"string"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// The EC2 unit limits for a managed scaling policy. The managed scaling activity
// of a cluster can not be above or below these limits. The limit only applies
// to the core and task nodes. The master node cannot be scaled after initial
// configuration.
type ComputeLimits struct {
	_ struct{} `type:"structure"`

	// The upper boundary of EC2 units. It is measured through VCPU cores or instances
	// for instance groups and measured through units for instance fleets. Managed
	// scaling activities are not allowed beyond this boundary. The limit only applies
	// to the core and task nodes. The master node cannot be scaled after initial
	// configuration.
	//
	// MaximumCapacityUnits is a required field
	MaximumCapacityUnits *int64 `type:"integer" required:"true"`

	// The upper boundary of EC2 units for core node type in a cluster. It is measured
	// through VCPU cores or instances for instance groups and measured through
	// units for instance fleets. The core units are not allowed to scale beyond
	// this boundary. The parameter is used to split capacity allocation between
	// core and task nodes.
	MaximumCoreCapacityUnits *int64 `type:"integer"`

	// The upper boundary of On-Demand EC2 units. It is measured through VCPU cores
	// or instances for instance groups and measured through units for instance
	// fleets. The On-Demand units are not allowed to scale beyond this boundary.
	// The parameter is used to split capacity allocation between On-Demand and
	// Spot instances.
	MaximumOnDemandCapacityUnits *int64 `type:"integer"`

	// The lower boundary of EC2 units. It is measured through VCPU cores or instances
	// for instance groups and measured through units for instance fleets. Managed
	// scaling activities are not allowed beyond this boundary. The limit only applies
	// to the core and task nodes. The master node cannot be scaled after initial
	// configuration.
	//
	// MinimumCapacityUnits is a required field
	MinimumCapacityUnits *int64 `type:"integer" required:"true"`

	// The unit type used for specifying a managed scaling policy.
	//
	// UnitType is a required field
	UnitType ComputeLimitsUnitType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ComputeLimits) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputeLimits) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComputeLimits"}

	if s.MaximumCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaximumCapacityUnits"))
	}

	if s.MinimumCapacityUnits == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinimumCapacityUnits"))
	}
	if len(s.UnitType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("UnitType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
// Amazon EMR releases 4.x or later.
//
// An optional configuration specification to be used when provisioning cluster
// instances, which can include configurations for applications and software
// bundled with Amazon EMR. A configuration consists of a classification, properties,
// and optional nested configurations. A classification refers to an application-specific
// configuration file. Properties are the settings you want to change in that
// file. For more information, see Configuring Applications (https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html).
type Configuration struct {
	_ struct{} `type:"structure"`

	// The classification within a configuration.
	Classification *string `type:"string"`

	// A list of additional configurations to apply within a configuration object.
	Configurations []Configuration `type:"list"`

	// A set of properties specified within a configuration classification.
	Properties map[string]string `type:"map"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// Configuration of requested EBS block device associated with the instance
// group.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// EBS volume specifications such as volume type, IOPS, and size (GiB) that
	// will be requested for the EBS volume attached to an EC2 instance in the cluster.
	VolumeSpecification *VolumeSpecification `type:"structure"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// Configuration of requested EBS block device associated with the instance
// group with count of volumes that will be associated to every instance.
type EbsBlockDeviceConfig struct {
	_ struct{} `type:"structure"`

	// EBS volume specifications such as volume type, IOPS, and size (GiB) that
	// will be requested for the EBS volume attached to an EC2 instance in the cluster.
	//
	// VolumeSpecification is a required field
	VolumeSpecification *VolumeSpecification `type:"structure" required:"true"`

	// Number of EBS volumes with a specific volume configuration that will be associated
	// with every instance in the instance group
	VolumesPerInstance *int64 `type:"integer"`
}

// String returns the string representation
func (s EbsBlockDeviceConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsBlockDeviceConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EbsBlockDeviceConfig"}

	if s.VolumeSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSpecification"))
	}
	if s.VolumeSpecification != nil {
		if err := s.VolumeSpecification.Validate(); err != nil {
			invalidParams.AddNested("VolumeSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon EBS configuration of a cluster instance.
type EbsConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of Amazon EBS volume specifications attached to a cluster instance.
	EbsBlockDeviceConfigs []EbsBlockDeviceConfig `type:"list"`

	// Indicates whether an Amazon EBS volume is EBS-optimized.
	EbsOptimized *bool `type:"boolean"`
}

// String returns the string representation
func (s EbsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EbsConfiguration"}
	if s.EbsBlockDeviceConfigs != nil {
		for i, v := range s.EbsBlockDeviceConfigs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EbsBlockDeviceConfigs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// EBS block device that's attached to an EC2 instance.
type EbsVolume struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh.
	Device *string `type:"string"`

	// The volume identifier of the EBS volume.
	VolumeId *string `type:"string"`
}

// String returns the string representation
func (s EbsVolume) String() string {
	return awsutil.Prettify(s)
}

// Provides information about the EC2 instances in a cluster grouped by category.
// For example, key name, subnet ID, IAM instance profile, and so on.
type Ec2InstanceAttributes struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the core and task
	// nodes.
	AdditionalSlaveSecurityGroups []string `type:"list"`

	// The Availability Zone in which the cluster will run.
	Ec2AvailabilityZone *string `type:"string"`

	// The name of the Amazon EC2 key pair to use when connecting with SSH into
	// the master node as a user named "hadoop".
	Ec2KeyName *string `type:"string"`

	// Set this parameter to the identifier of the Amazon VPC subnet where you want
	// the cluster to launch. If you do not specify this value, and your account
	// supports EC2-Classic, the cluster launches in EC2-Classic.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the core and task nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The IAM role that was specified when the cluster was launched. The EC2 instances
	// of the cluster assume this role.
	IamInstanceProfile *string `type:"string"`

	// Applies to clusters configured with the instance fleets option. Specifies
	// one or more Availability Zones in which to launch EC2 cluster instances when
	// the EC2-Classic network configuration is supported. Amazon EMR chooses the
	// Availability Zone with the best fit from among the list of RequestedEc2AvailabilityZones,
	// and then launches all cluster instances within that Availability Zone. If
	// you do not specify this value, Amazon EMR chooses the Availability Zone for
	// you. RequestedEc2SubnetIDs and RequestedEc2AvailabilityZones cannot be specified
	// together.
	RequestedEc2AvailabilityZones []string `type:"list"`

	// Applies to clusters configured with the instance fleets option. Specifies
	// the unique identifier of one or more Amazon EC2 subnets in which to launch
	// EC2 cluster instances. Subnets must exist within the same VPC. Amazon EMR
	// chooses the EC2 subnet with the best fit from among the list of RequestedEc2SubnetIds,
	// and then launches all cluster instances within that Subnet. If this value
	// is not specified, and the account and Region support EC2-Classic networks,
	// the cluster launches instances in the EC2-Classic network and uses RequestedEc2AvailabilityZones
	// instead of this setting. If EC2-Classic is not supported, and no Subnet is
	// specified, Amazon EMR chooses the subnet for you. RequestedEc2SubnetIDs and
	// RequestedEc2AvailabilityZones cannot be specified together.
	RequestedEc2SubnetIds []string `type:"list"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`
}

// String returns the string representation
func (s Ec2InstanceAttributes) String() string {
	return awsutil.Prettify(s)
}

// The details of the step failure. The service attempts to detect the root
// cause for many common failures.
type FailureDetails struct {
	_ struct{} `type:"structure"`

	// The path to the log file where the step failure root cause was originally
	// recorded.
	LogFile *string `type:"string"`

	// The descriptive message including the error the EMR service has identified
	// as the cause of step failure. This is text from an error log that describes
	// the root cause of the failure.
	Message *string `type:"string"`

	// The reason for the step failure. In the case where the service cannot successfully
	// determine the root cause of the failure, it returns "Unknown Error" as a
	// reason.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// A job flow step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopJarStepConfig struct {
	_ struct{} `type:"structure"`

	// A list of command line arguments passed to the JAR file's main function when
	// executed.
	Args []string `type:"list"`

	// A path to a JAR file run during the step.
	//
	// Jar is a required field
	Jar *string `type:"string" required:"true"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a Main-Class in its manifest file.
	MainClass *string `type:"string"`

	// A list of Java properties that are set when the step runs. You can use these
	// properties to pass key value pairs to your main function.
	Properties []KeyValue `type:"list"`
}

// String returns the string representation
func (s HadoopJarStepConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HadoopJarStepConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HadoopJarStepConfig"}

	if s.Jar == nil {
		invalidParams.Add(aws.NewErrParamRequired("Jar"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A cluster step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopStepConfig struct {
	_ struct{} `type:"structure"`

	// The list of command line arguments to pass to the JAR file's main function
	// for execution.
	Args []string `type:"list"`

	// The path to the JAR file that runs during the step.
	Jar *string `type:"string"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a main class in its manifest file.
	MainClass *string `type:"string"`

	// The list of Java properties that are set when the step runs. You can use
	// these properties to pass key value pairs to your main function.
	Properties map[string]string `type:"map"`
}

// String returns the string representation
func (s HadoopStepConfig) String() string {
	return awsutil.Prettify(s)
}

// Represents an EC2 instance provisioned as part of cluster.
type Instance struct {
	_ struct{} `type:"structure"`

	// The list of EBS volumes that are attached to this instance.
	EbsVolumes []EbsVolume `type:"list"`

	// The unique identifier of the instance in Amazon EC2.
	Ec2InstanceId *string `type:"string"`

	// The unique identifier for the instance in Amazon EMR.
	Id *string `type:"string"`

	// The unique identifier of the instance fleet to which an EC2 instance belongs.
	InstanceFleetId *string `type:"string"`

	// The identifier of the instance group to which this instance belongs.
	InstanceGroupId *string `type:"string"`

	// The EC2 instance type, for example m3.xlarge.
	InstanceType *string `min:"1" type:"string"`

	// The instance purchasing option. Valid values are ON_DEMAND or SPOT.
	Market MarketType `type:"string" enum:"true"`

	// The private DNS name of the instance.
	PrivateDnsName *string `type:"string"`

	// The private IP address of the instance.
	PrivateIpAddress *string `type:"string"`

	// The public DNS name of the instance.
	PublicDnsName *string `type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `type:"string"`

	// The current status of the instance.
	Status *InstanceStatus `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Describes an instance fleet, which is a group of EC2 instances that host
// a particular node type (master, core, or task) in an Amazon EMR cluster.
// Instance fleets can consist of a mix of instance types and On-Demand and
// Spot instances, which are provisioned to meet a defined target capacity.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleet struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the instance fleet.
	Id *string `type:"string"`

	// The node type that the instance fleet hosts. Valid values are MASTER, CORE,
	// or TASK.
	InstanceFleetType InstanceFleetType `type:"string" enum:"true"`

	// The specification for the instance types that comprise an instance fleet.
	// Up to five unique instance specifications may be defined for each instance
	// fleet.
	InstanceTypeSpecifications []InstanceTypeSpecification `type:"list"`

	// Describes the launch specification for an instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications `type:"structure"`

	// A friendly name for the instance fleet.
	Name *string `type:"string"`

	// The number of On-Demand units that have been provisioned for the instance
	// fleet to fulfill TargetOnDemandCapacity. This provisioned capacity might
	// be less than or greater than TargetOnDemandCapacity.
	ProvisionedOnDemandCapacity *int64 `type:"integer"`

	// The number of Spot units that have been provisioned for this instance fleet
	// to fulfill TargetSpotCapacity. This provisioned capacity might be less than
	// or greater than TargetSpotCapacity.
	ProvisionedSpotCapacity *int64 `type:"integer"`

	// The current status of the instance fleet.
	Status *InstanceFleetStatus `type:"structure"`

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When an On-Demand
	// instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedOnDemandCapacity
	// to determine the Spot capacity units that have been provisioned for the instance
	// fleet.
	//
	// If not specified or set to 0, only Spot instances are provisioned for the
	// instance fleet using TargetSpotCapacity. At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be specified,
	// and its value must be 1.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet, which determines
	// how many Spot instances to provision. When the instance fleet launches, Amazon
	// EMR tries to provision Spot instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When a Spot
	// instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units. You can use InstanceFleet$ProvisionedSpotCapacity
	// to determine the Spot capacity units that have been provisioned for the instance
	// fleet.
	//
	// If not specified or set to 0, only On-Demand instances are provisioned for
	// the instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of TargetSpotCapacity
	// and TargetOnDemandCapacity can be specified, and its value must be 1.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleet) String() string {
	return awsutil.Prettify(s)
}

// The configuration that defines an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetConfig struct {
	_ struct{} `type:"structure"`

	// The node type that the instance fleet hosts. Valid values are MASTER,CORE,and
	// TASK.
	//
	// InstanceFleetType is a required field
	InstanceFleetType InstanceFleetType `type:"string" required:"true" enum:"true"`

	// The instance type configurations that define the EC2 instances in the instance
	// fleet.
	InstanceTypeConfigs []InstanceTypeConfig `type:"list"`

	// The launch specification for the instance fleet.
	LaunchSpecifications *InstanceFleetProvisioningSpecifications `type:"structure"`

	// The friendly name of the instance fleet.
	Name *string `type:"string"`

	// The target capacity of On-Demand units for the instance fleet, which determines
	// how many On-Demand instances to provision. When the instance fleet launches,
	// Amazon EMR tries to provision On-Demand instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When an On-Demand
	// instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units.
	//
	// If not specified or set to 0, only Spot instances are provisioned for the
	// instance fleet using TargetSpotCapacity. At least one of TargetSpotCapacity
	// and TargetOnDemandCapacity should be greater than 0. For a master instance
	// fleet, only one of TargetSpotCapacity and TargetOnDemandCapacity can be specified,
	// and its value must be 1.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet, which determines
	// how many Spot instances to provision. When the instance fleet launches, Amazon
	// EMR tries to provision Spot instances as specified by InstanceTypeConfig.
	// Each instance configuration has a specified WeightedCapacity. When a Spot
	// instance is provisioned, the WeightedCapacity units count toward the target
	// capacity. Amazon EMR provisions instances until the target capacity is totally
	// fulfilled, even if this results in an overage. For example, if there are
	// 2 units remaining to fulfill capacity, and Amazon EMR can only provision
	// an instance with a WeightedCapacity of 5 units, the instance is provisioned,
	// and the target capacity is exceeded by 3 units.
	//
	// If not specified or set to 0, only On-Demand instances are provisioned for
	// the instance fleet. At least one of TargetSpotCapacity and TargetOnDemandCapacity
	// should be greater than 0. For a master instance fleet, only one of TargetSpotCapacity
	// and TargetOnDemandCapacity can be specified, and its value must be 1.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleetConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceFleetConfig"}
	if len(s.InstanceFleetType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceFleetType"))
	}
	if s.InstanceTypeConfigs != nil {
		for i, v := range s.InstanceTypeConfigs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceTypeConfigs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.LaunchSpecifications != nil {
		if err := s.LaunchSpecifications.Validate(); err != nil {
			invalidParams.AddNested("LaunchSpecifications", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration parameters for an instance fleet modification request.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetModifyConfig struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the instance fleet.
	//
	// InstanceFleetId is a required field
	InstanceFleetId *string `type:"string" required:"true"`

	// The target capacity of On-Demand units for the instance fleet. For more information
	// see InstanceFleetConfig$TargetOnDemandCapacity.
	TargetOnDemandCapacity *int64 `type:"integer"`

	// The target capacity of Spot units for the instance fleet. For more information,
	// see InstanceFleetConfig$TargetSpotCapacity.
	TargetSpotCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceFleetModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetModifyConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceFleetModifyConfig"}

	if s.InstanceFleetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceFleetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The launch specification for Spot instances in the fleet, which determines
// the defined duration, provisioning timeout behavior, and allocation strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. On-Demand and Spot instance allocation
// strategies are available in Amazon EMR version 5.12.1 and later.
type InstanceFleetProvisioningSpecifications struct {
	_ struct{} `type:"structure"`

	// The launch specification for On-Demand instances in the instance fleet, which
	// determines the allocation strategy.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions. On-Demand instances allocation
	// strategy is available in Amazon EMR version 5.12.1 and later.
	OnDemandSpecification *OnDemandProvisioningSpecification `type:"structure"`

	// The launch specification for Spot instances in the fleet, which determines
	// the defined duration, provisioning timeout behavior, and allocation strategy.
	SpotSpecification *SpotProvisioningSpecification `type:"structure"`
}

// String returns the string representation
func (s InstanceFleetProvisioningSpecifications) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceFleetProvisioningSpecifications) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceFleetProvisioningSpecifications"}
	if s.OnDemandSpecification != nil {
		if err := s.OnDemandSpecification.Validate(); err != nil {
			invalidParams.AddNested("OnDemandSpecification", err.(aws.ErrInvalidParams))
		}
	}
	if s.SpotSpecification != nil {
		if err := s.SpotSpecification.Validate(); err != nil {
			invalidParams.AddNested("SpotSpecification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides status change reason details for the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetStateChangeReason struct {
	_ struct{} `type:"structure"`

	// A code corresponding to the reason the state change occurred.
	Code InstanceFleetStateChangeReasonCode `type:"string" enum:"true"`

	// An explanatory message.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceFleetStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The status of the instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetStatus struct {
	_ struct{} `type:"structure"`

	// A code representing the instance fleet status.
	//
	//    * PROVISIONING—The instance fleet is provisioning EC2 resources and
	//    is not yet ready to run jobs.
	//
	//    * BOOTSTRAPPING—EC2 instances and other resources have been provisioned
	//    and the bootstrap actions specified for the instances are underway.
	//
	//    * RUNNING—EC2 instances and other resources are running. They are either
	//    executing jobs or waiting to execute jobs.
	//
	//    * RESIZING—A resize operation is underway. EC2 instances are either
	//    being added or removed.
	//
	//    * SUSPENDED—A resize operation could not complete. Existing EC2 instances
	//    are running, but instances can't be added or removed.
	//
	//    * TERMINATING—The instance fleet is terminating EC2 instances.
	//
	//    * TERMINATED—The instance fleet is no longer active, and all EC2 instances
	//    have been terminated.
	State InstanceFleetState `type:"string" enum:"true"`

	// Provides status change reason details for the instance fleet.
	StateChangeReason *InstanceFleetStateChangeReason `type:"structure"`

	// Provides historical timestamps for the instance fleet, including the time
	// of creation, the time it became ready to run jobs, and the time of termination.
	Timeline *InstanceFleetTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceFleetStatus) String() string {
	return awsutil.Prettify(s)
}

// Provides historical timestamps for the instance fleet, including the time
// of creation, the time it became ready to run jobs, and the time of termination.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceFleetTimeline struct {
	_ struct{} `type:"structure"`

	// The time and date the instance fleet was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The time and date the instance fleet terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The time and date the instance fleet was ready to run jobs.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceFleetTimeline) String() string {
	return awsutil.Prettify(s)
}

// This entity represents an instance group, which is a group of instances that
// have common purpose. For example, CORE instance group is used for HDFS.
type InstanceGroup struct {
	_ struct{} `type:"structure"`

	// An automatic scaling policy for a core instance group or task instance group
	// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates EC2 instances in response to the value
	// of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicyDescription `type:"structure"`

	// The bid price for each EC2 Spot instance type as defined by InstanceType.
	// Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string `type:"string"`

	//
	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []Configuration `type:"list"`

	// The version number of the requested configuration specification for this
	// instance group.
	ConfigurationsVersion *int64 `type:"long"`

	// The EBS block devices that are mapped to this instance group.
	EbsBlockDevices []EbsBlockDevice `type:"list"`

	// If the instance group is EBS-optimized. An Amazon EBS-optimized instance
	// uses an optimized configuration stack and provides additional, dedicated
	// capacity for Amazon EBS I/O.
	EbsOptimized *bool `type:"boolean"`

	// The identifier of the instance group.
	Id *string `type:"string"`

	// The type of the instance group. Valid values are MASTER, CORE or TASK.
	InstanceGroupType InstanceGroupType `type:"string" enum:"true"`

	// The EC2 instance type for all instances in the instance group.
	InstanceType *string `min:"1" type:"string"`

	// A list of configurations that were successfully applied for an instance group
	// last time.
	LastSuccessfullyAppliedConfigurations []Configuration `type:"list"`

	// The version number of a configuration specification that was successfully
	// applied for an instance group last time.
	LastSuccessfullyAppliedConfigurationsVersion *int64 `type:"long"`

	// The marketplace to provision instances for this group. Valid values are ON_DEMAND
	// or SPOT.
	Market MarketType `type:"string" enum:"true"`

	// The name of the instance group.
	Name *string `type:"string"`

	// The target number of instances for the instance group.
	RequestedInstanceCount *int64 `type:"integer"`

	// The number of instances currently running in this instance group.
	RunningInstanceCount *int64 `type:"integer"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`

	// The current status of the instance group.
	Status *InstanceGroupStatus `type:"structure"`
}

// String returns the string representation
func (s InstanceGroup) String() string {
	return awsutil.Prettify(s)
}

// Configuration defining a new instance group.
type InstanceGroupConfig struct {
	_ struct{} `type:"structure"`

	// An automatic scaling policy for a core instance group or task instance group
	// in an Amazon EMR cluster. The automatic scaling policy defines how an instance
	// group dynamically adds and terminates EC2 instances in response to the value
	// of a CloudWatch metric. See PutAutoScalingPolicy.
	AutoScalingPolicy *AutoScalingPolicy `type:"structure"`

	// The bid price for each EC2 Spot instance type as defined by InstanceType.
	// Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string `type:"string"`

	//
	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []Configuration `type:"list"`

	// EBS configurations that will be attached to each EC2 instance in the instance
	// group.
	EbsConfiguration *EbsConfiguration `type:"structure"`

	// Target number of instances for the instance group.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// The role of the instance group in the cluster.
	//
	// InstanceRole is a required field
	InstanceRole InstanceRoleType `type:"string" required:"true" enum:"true"`

	// The EC2 instance type for all instances in the instance group.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Market type of the EC2 instances used to create a cluster node.
	Market MarketType `type:"string" enum:"true"`

	// Friendly name given to the instance group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceGroupConfig"}

	if s.InstanceCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceCount"))
	}
	if len(s.InstanceRole) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("InstanceRole"))
	}

	if s.InstanceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}
	if s.AutoScalingPolicy != nil {
		if err := s.AutoScalingPolicy.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.EbsConfiguration != nil {
		if err := s.EbsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Detailed information about an instance group.
type InstanceGroupDetail struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 Spot instance type as defined by InstanceType.
	// Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string `type:"string"`

	// The date/time the instance group was created.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The date/time the instance group was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// Unique identifier for the instance group.
	InstanceGroupId *string `type:"string"`

	// Target number of instances to run in the instance group.
	//
	// InstanceRequestCount is a required field
	InstanceRequestCount *int64 `type:"integer" required:"true"`

	// Instance group role in the cluster
	//
	// InstanceRole is a required field
	InstanceRole InstanceRoleType `type:"string" required:"true" enum:"true"`

	// Actual count of running instances.
	//
	// InstanceRunningCount is a required field
	InstanceRunningCount *int64 `type:"integer" required:"true"`

	// EC2 instance type.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Details regarding the state of the instance group.
	LastStateChangeReason *string `type:"string"`

	// Market type of the EC2 instances used to create a cluster node.
	//
	// Market is a required field
	Market MarketType `type:"string" required:"true" enum:"true"`

	// Friendly name for the instance group.
	Name *string `type:"string"`

	// The date/time the instance group was available to the cluster.
	ReadyDateTime *time.Time `type:"timestamp"`

	// The date/time the instance group was started.
	StartDateTime *time.Time `type:"timestamp"`

	// State of instance group. The following values are deprecated: STARTING, TERMINATED,
	// and FAILED.
	//
	// State is a required field
	State InstanceGroupState `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s InstanceGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// Modify the size or configurations of an instance group.
type InstanceGroupModifyConfig struct {
	_ struct{} `type:"structure"`

	// A list of new or modified configurations to apply for an instance group.
	Configurations []Configuration `type:"list"`

	// The EC2 InstanceIds to terminate. After you terminate the instances, the
	// instance group will not return to its original requested size.
	EC2InstanceIdsToTerminate []string `type:"list"`

	// Target size for the instance group.
	InstanceCount *int64 `type:"integer"`

	// Unique ID of the instance group to expand or shrink.
	//
	// InstanceGroupId is a required field
	InstanceGroupId *string `type:"string" required:"true"`

	// Policy for customizing shrink operations.
	ShrinkPolicy *ShrinkPolicy `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceGroupModifyConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceGroupModifyConfig"}

	if s.InstanceGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceGroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status change reason details for the instance group.
type InstanceGroupStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code InstanceGroupStateChangeReasonCode `type:"string" enum:"true"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceGroupStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The details of the instance group status.
type InstanceGroupStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance group.
	State InstanceGroupState `type:"string" enum:"true"`

	// The status change reason details for the instance group.
	StateChangeReason *InstanceGroupStateChangeReason `type:"structure"`

	// The timeline of the instance group status over time.
	Timeline *InstanceGroupTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// The timeline of the instance group lifecycle.
type InstanceGroupTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance group.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance group terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance group became ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceGroupTimeline) String() string {
	return awsutil.Prettify(s)
}

// Custom policy for requesting termination protection or termination of specific
// instances when shrinking an instance group.
type InstanceResizePolicy struct {
	_ struct{} `type:"structure"`

	// Decommissioning timeout override for the specific list of instances to be
	// terminated.
	InstanceTerminationTimeout *int64 `type:"integer"`

	// Specific list of instances to be protected when shrinking an instance group.
	InstancesToProtect []string `type:"list"`

	// Specific list of instances to be terminated when shrinking an instance group.
	InstancesToTerminate []string `type:"list"`
}

// String returns the string representation
func (s InstanceResizePolicy) String() string {
	return awsutil.Prettify(s)
}

// The details of the status change reason for the instance.
type InstanceStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason.
	Code InstanceStateChangeReasonCode `type:"string" enum:"true"`

	// The status change reason description.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstanceStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The instance status details.
type InstanceStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the instance.
	State InstanceState `type:"string" enum:"true"`

	// The details of the status change reason for the instance.
	StateChangeReason *InstanceStateChangeReason `type:"structure"`

	// The timeline of the instance status over time.
	Timeline *InstanceTimeline `type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// The timeline of the instance lifecycle.
type InstanceTimeline struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the instance.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance was terminated.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the instance was ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s InstanceTimeline) String() string {
	return awsutil.Prettify(s)
}

// An instance type configuration for each instance type in an instance fleet,
// which determines the EC2 instances Amazon EMR attempts to provision to fulfill
// On-Demand and Spot target capacities. There can be a maximum of 5 instance
// type configurations in a fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceTypeConfig struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 Spot instance type as defined by InstanceType.
	// Expressed in USD. If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice
	// is provided, BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPrice *string `type:"string"`

	// The bid price, as a percentage of On-Demand price, for each EC2 Spot instance
	// as defined by InstanceType. Expressed as a number (for example, 20 specifies
	// 20%). If neither BidPrice nor BidPriceAsPercentageOfOnDemandPrice is provided,
	// BidPriceAsPercentageOfOnDemandPrice defaults to 100%.
	BidPriceAsPercentageOfOnDemandPrice *float64 `type:"double"`

	// A configuration classification that applies when provisioning cluster instances,
	// which can include configurations for applications and software that run on
	// the cluster.
	Configurations []Configuration `type:"list"`

	// The configuration of Amazon Elastic Block Storage (EBS) attached to each
	// instance as defined by InstanceType.
	EbsConfiguration *EbsConfiguration `type:"structure"`

	// An EC2 instance type, such as m3.xlarge.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. This value
	// is 1 for a master instance fleet, and must be 1 or greater for core and task
	// instance fleets. Defaults to 1 if not specified.
	WeightedCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceTypeConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceTypeConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceTypeConfig"}

	if s.InstanceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}
	if s.EbsConfiguration != nil {
		if err := s.EbsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EbsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration specification for each instance type in an instance fleet.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
type InstanceTypeSpecification struct {
	_ struct{} `type:"structure"`

	// The bid price for each EC2 Spot instance type as defined by InstanceType.
	// Expressed in USD.
	BidPrice *string `type:"string"`

	// The bid price, as a percentage of On-Demand price, for each EC2 Spot instance
	// as defined by InstanceType. Expressed as a number (for example, 20 specifies
	// 20%).
	BidPriceAsPercentageOfOnDemandPrice *float64 `type:"double"`

	// A configuration classification that applies when provisioning cluster instances,
	// which can include configurations for applications and software bundled with
	// Amazon EMR.
	Configurations []Configuration `type:"list"`

	// The configuration of Amazon Elastic Block Storage (EBS) attached to each
	// instance as defined by InstanceType.
	EbsBlockDevices []EbsBlockDevice `type:"list"`

	// Evaluates to TRUE when the specified InstanceType is EBS-optimized.
	EbsOptimized *bool `type:"boolean"`

	// The EC2 instance type, for example m3.xlarge.
	InstanceType *string `min:"1" type:"string"`

	// The number of units that a provisioned instance of this type provides toward
	// fulfilling the target capacities defined in InstanceFleetConfig. Capacity
	// values represent performance characteristics such as vCPUs, memory, or I/O.
	// If not specified, the default value is 1.
	WeightedCapacity *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceTypeSpecification) String() string {
	return awsutil.Prettify(s)
}

// A description of a cluster (job flow).
type JobFlowDetail struct {
	_ struct{} `type:"structure"`

	// Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases
	// 4.0 and later, ReleaseLabel is used. To specify a custom AMI, use CustomAmiID.
	AmiVersion *string `type:"string"`

	// An IAM role for automatic scaling policies. The default role is EMR_AutoScaling_DefaultRole.
	// The IAM role provides a way for the automatic scaling feature to get the
	// required permissions it needs to launch and terminate EC2 instances in an
	// instance group.
	AutoScalingRole *string `type:"string"`

	// A list of the bootstrap actions run by the job flow.
	BootstrapActions []BootstrapActionDetail `type:"list"`

	// Describes the execution status of the job flow.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *JobFlowExecutionStatusDetail `type:"structure" required:"true"`

	// Describes the Amazon EC2 instances of the job flow.
	//
	// Instances is a required field
	Instances *JobFlowInstancesDetail `type:"structure" required:"true"`

	// The job flow identifier.
	//
	// JobFlowId is a required field
	JobFlowId *string `type:"string" required:"true"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	JobFlowRole *string `type:"string"`

	// The AWS KMS customer master key (CMK) used for encrypting log files. This
	// attribute is only available with EMR version 5.30.0 and later, excluding
	// EMR 6.0.0.
	LogEncryptionKmsKeyId *string `type:"string"`

	// The location in Amazon S3 where log files for the job are stored.
	LogUri *string `type:"string"`

	// The name of the job flow.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The way that individual Amazon EC2 instances terminate when an automatic
	// scale-in activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
	// indicates that Amazon EMR terminates nodes at the instance-hour boundary,
	// regardless of when the request to terminate the instance was submitted. This
	// option is only available with Amazon EMR 5.1.0 and later and is the default
	// for clusters created using that version. TERMINATE_AT_TASK_COMPLETION indicates
	// that Amazon EMR blacklists and drains tasks from nodes before terminating
	// the Amazon EC2 instances, regardless of the instance-hour boundary. With
	// either behavior, Amazon EMR removes the least active nodes first and blocks
	// instance termination if it could lead to HDFS corruption. TERMINATE_AT_TASK_COMPLETION
	// available only in Amazon EMR version 4.1.0 and later, and is the default
	// for versions of Amazon EMR earlier than 5.1.0.
	ScaleDownBehavior ScaleDownBehavior `type:"string" enum:"true"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps run by the job flow.
	Steps []StepDetail `type:"list"`

	// A list of strings set by third party software when the job flow is launched.
	// If you are not using third party software to manage the job flow this value
	// is empty.
	SupportedProducts []string `type:"list"`

	// Indicates whether the cluster is visible to all IAM users of the AWS account
	// associated with the cluster. The default value, true, indicates that all
	// IAM users in the AWS account can perform cluster actions if they have the
	// proper IAM policy permissions. If this value is false, only the IAM user
	// that created the cluster can perform actions. This value can be changed on
	// a running cluster by using the SetVisibleToAllUsers action. You can override
	// the default value of true when you create a cluster by using the VisibleToAllUsers
	// parameter of the RunJobFlow action.
	VisibleToAllUsers *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowDetail) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of the cluster (job flow).
type JobFlowExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the job flow.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The completion date and time of the job flow.
	EndDateTime *time.Time `type:"timestamp"`

	// Description of the job flow last changed state.
	LastStateChangeReason *string `type:"string"`

	// The date and time when the job flow was ready to start running bootstrap
	// actions.
	ReadyDateTime *time.Time `type:"timestamp"`

	// The start date and time of the job flow.
	StartDateTime *time.Time `type:"timestamp"`

	// The state of the job flow.
	//
	// State is a required field
	State JobFlowExecutionState `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s JobFlowExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// A description of the Amazon EC2 instance on which the cluster (job flow)
// runs. A valid JobFlowInstancesConfig must contain either InstanceGroups or
// InstanceFleets, which is the recommended configuration. They cannot be used
// together. You may also have MasterInstanceType, SlaveInstanceType, and InstanceCount
// (all three must be present), but we don't recommend this configuration.
type JobFlowInstancesConfig struct {
	_ struct{} `type:"structure"`

	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the core and task
	// nodes.
	AdditionalSlaveSecurityGroups []string `type:"list"`

	// The name of the EC2 key pair that can be used to ssh to the master node as
	// the user called "hadoop."
	Ec2KeyName *string `type:"string"`

	// Applies to clusters that use the uniform instance group configuration. To
	// launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this
	// parameter to the identifier of the Amazon VPC subnet where you want the cluster
	// to launch. If you do not specify this value and your account supports EC2-Classic,
	// the cluster launches in EC2-Classic.
	Ec2SubnetId *string `type:"string"`

	// Applies to clusters that use the instance fleet configuration. When multiple
	// EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances
	// in the optimal subnet.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	Ec2SubnetIds []string `type:"list"`

	// The identifier of the Amazon EC2 security group for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group for the core and task nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop
	// version for the cluster. Valid inputs are "0.18" (deprecated), "0.20" (deprecated),
	// "0.20.205" (deprecated), "1.0.3", "2.2.0", or "2.4.0". If you do not set
	// this value, the default of 0.18 is used, unless the AmiVersion parameter
	// is set in the RunJobFlow call, in which case the default version of Hadoop
	// for that AMI version is used.
	HadoopVersion *string `type:"string"`

	// The number of EC2 instances in the cluster.
	InstanceCount *int64 `type:"integer"`

	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	//
	// Describes the EC2 instances and instance configurations for clusters that
	// use the instance fleet configuration.
	InstanceFleets []InstanceFleetConfig `type:"list"`

	// Configuration for the instance groups in a cluster.
	InstanceGroups []InstanceGroupConfig `type:"list"`

	// Specifies whether the cluster should remain available after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The EC2 instance type of the master node.
	MasterInstanceType *string `min:"1" type:"string"`

	// The Availability Zone in which the cluster runs.
	Placement *PlacementType `type:"structure"`

	// The identifier of the Amazon EC2 security group for the Amazon EMR service
	// to access clusters in VPC private subnets.
	ServiceAccessSecurityGroup *string `type:"string"`

	// The EC2 instance type of the core and task nodes.
	SlaveInstanceType *string `min:"1" type:"string"`

	// Specifies whether to lock the cluster to prevent the Amazon EC2 instances
	// from being terminated by API call, user intervention, or in the event of
	// a job-flow error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobFlowInstancesConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobFlowInstancesConfig"}
	if s.MasterInstanceType != nil && len(*s.MasterInstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MasterInstanceType", 1))
	}
	if s.SlaveInstanceType != nil && len(*s.SlaveInstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SlaveInstanceType", 1))
	}
	if s.InstanceFleets != nil {
		for i, v := range s.InstanceFleets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceFleets", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.InstanceGroups != nil {
		for i, v := range s.InstanceGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InstanceGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specify the type of Amazon EC2 instances that the cluster (job flow) runs
// on.
type JobFlowInstancesDetail struct {
	_ struct{} `type:"structure"`

	// The name of an Amazon EC2 key pair that can be used to ssh to the master
	// node.
	Ec2KeyName *string `type:"string"`

	// For clusters launched within Amazon Virtual Private Cloud, this is the identifier
	// of the subnet where the cluster was launched.
	Ec2SubnetId *string `type:"string"`

	// The Hadoop version for the cluster.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances in the cluster. If the value is 1, the
	// same instance serves as both the master and core and task node. If the value
	// is greater than 1, one instance is the master node and all others are core
	// and task nodes.
	//
	// InstanceCount is a required field
	InstanceCount *int64 `type:"integer" required:"true"`

	// Details about the instance groups in a cluster.
	InstanceGroups []InstanceGroupDetail `type:"list"`

	// Specifies whether the cluster should remain available after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The Amazon EC2 instance identifier of the master node.
	MasterInstanceId *string `type:"string"`

	// The Amazon EC2 master node instance type.
	//
	// MasterInstanceType is a required field
	MasterInstanceType *string `min:"1" type:"string" required:"true"`

	// The DNS name of the master node. If the cluster is on a private subnet, this
	// is the private DNS name. On a public subnet, this is the public DNS name.
	MasterPublicDnsName *string `type:"string"`

	// An approximation of the cost of the cluster, represented in m1.small/hours.
	// This value is incremented one time for every hour that an m1.small runs.
	// Larger instances are weighted more, so an Amazon EC2 instance that is roughly
	// four times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone for the cluster.
	Placement *PlacementType `type:"structure"`

	// The Amazon EC2 core and task node instance type.
	//
	// SlaveInstanceType is a required field
	SlaveInstanceType *string `min:"1" type:"string" required:"true"`

	// Specifies whether the Amazon EC2 instances in the cluster are protected from
	// termination by API calls, user intervention, or in the event of a job-flow
	// error.
	TerminationProtected *bool `type:"boolean"`
}

// String returns the string representation
func (s JobFlowInstancesDetail) String() string {
	return awsutil.Prettify(s)
}

// Attributes for Kerberos configuration when Kerberos authentication is enabled
// using a security configuration. For more information see Use Kerberos Authentication
// (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
// in the EMR Management Guide.
type KerberosAttributes struct {
	_ struct{} `type:"structure"`

	// The Active Directory password for ADDomainJoinUser.
	ADDomainJoinPassword *string `type:"string"`

	// Required only when establishing a cross-realm trust with an Active Directory
	// domain. A user with sufficient privileges to join resources to the domain.
	ADDomainJoinUser *string `type:"string"`

	// Required only when establishing a cross-realm trust with a KDC in a different
	// realm. The cross-realm principal password, which must be identical across
	// realms.
	CrossRealmTrustPrincipalPassword *string `type:"string"`

	// The password used within the cluster for the kadmin service on the cluster-dedicated
	// KDC, which maintains Kerberos principals, password policies, and keytabs
	// for the cluster.
	//
	// KdcAdminPassword is a required field
	KdcAdminPassword *string `type:"string" required:"true"`

	// The name of the Kerberos realm to which all nodes in a cluster belong. For
	// example, EC2.INTERNAL.
	//
	// Realm is a required field
	Realm *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KerberosAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KerberosAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KerberosAttributes"}

	if s.KdcAdminPassword == nil {
		invalidParams.Add(aws.NewErrParamRequired("KdcAdminPassword"))
	}

	if s.Realm == nil {
		invalidParams.Add(aws.NewErrParamRequired("Realm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A key value pair.
type KeyValue struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a key value pair.
	Key *string `type:"string"`

	// The value part of the identified key.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeyValue) String() string {
	return awsutil.Prettify(s)
}

// Managed scaling policy for an Amazon EMR cluster. The policy specifies the
// limits for resources that can be added or terminated from a cluster. The
// policy only applies to the core and task nodes. The master node cannot be
// scaled after initial configuration.
type ManagedScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The EC2 unit limits for a managed scaling policy. The managed scaling activity
	// of a cluster is not allowed to go above or below these limits. The limit
	// only applies to the core and task nodes. The master node cannot be scaled
	// after initial configuration.
	ComputeLimits *ComputeLimits `type:"structure"`
}

// String returns the string representation
func (s ManagedScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManagedScalingPolicy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ManagedScalingPolicy"}
	if s.ComputeLimits != nil {
		if err := s.ComputeLimits.Validate(); err != nil {
			invalidParams.AddNested("ComputeLimits", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A CloudWatch dimension, which is specified using a Key (known as a Name in
// CloudWatch), Value pair. By default, Amazon EMR uses one dimension whose
// Key is JobFlowID and Value is a variable representing the cluster ID, which
// is ${emr.clusterId}. This enables the rule to bootstrap when the cluster
// ID becomes available.
type MetricDimension struct {
	_ struct{} `type:"structure"`

	// The dimension name.
	Key *string `type:"string"`

	// The dimension value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MetricDimension) String() string {
	return awsutil.Prettify(s)
}

// The launch specification for On-Demand instances in the instance fleet, which
// determines the allocation strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. On-Demand instances allocation
// strategy is available in Amazon EMR version 5.12.1 and later.
type OnDemandProvisioningSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the strategy to use in launching On-Demand instance fleets. Currently,
	// the only option is lowest-price (the default), which launches the lowest
	// price first.
	//
	// AllocationStrategy is a required field
	AllocationStrategy OnDemandProvisioningAllocationStrategy `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s OnDemandProvisioningSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OnDemandProvisioningSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OnDemandProvisioningSpecification"}
	if len(s.AllocationStrategy) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AllocationStrategy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon EC2 Availability Zone configuration of the cluster (job flow).
type PlacementType struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 Availability Zone for the cluster. AvailabilityZone is used
	// for uniform instance groups, while AvailabilityZones (plural) is used for
	// instance fleets.
	AvailabilityZone *string `type:"string"`

	// When multiple Availability Zones are specified, Amazon EMR evaluates them
	// and launches instances in the optimal Availability Zone. AvailabilityZones
	// is used for instance fleets, while AvailabilityZone (singular) is used for
	// uniform instance groups.
	//
	// The instance fleet configuration is available only in Amazon EMR versions
	// 4.8.0 and later, excluding 5.0.x versions.
	AvailabilityZones []string `type:"list"`
}

// String returns the string representation
func (s PlacementType) String() string {
	return awsutil.Prettify(s)
}

// A list of port ranges that are permitted to allow inbound traffic from all
// public IP addresses. To specify a single port, use the same value for MinRange
// and MaxRange.
type PortRange struct {
	_ struct{} `type:"structure"`

	// The smallest port number in a specified range of port numbers.
	MaxRange *int64 `type:"integer"`

	// The smallest port number in a specified range of port numbers.
	//
	// MinRange is a required field
	MinRange *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s PortRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PortRange"}

	if s.MinRange == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinRange"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The type of adjustment the automatic scaling activity makes when triggered,
// and the periodicity of the adjustment.
type ScalingAction struct {
	_ struct{} `type:"structure"`

	// Not available for instance groups. Instance groups use the market type specified
	// for the group.
	Market MarketType `type:"string" enum:"true"`

	// The type of adjustment the automatic scaling activity makes when triggered,
	// and the periodicity of the adjustment.
	//
	// SimpleScalingPolicyConfiguration is a required field
	SimpleScalingPolicyConfiguration *SimpleScalingPolicyConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScalingAction"}

	if s.SimpleScalingPolicyConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("SimpleScalingPolicyConfiguration"))
	}
	if s.SimpleScalingPolicyConfiguration != nil {
		if err := s.SimpleScalingPolicyConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SimpleScalingPolicyConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The upper and lower EC2 instance limits for an automatic scaling policy.
// Automatic scaling activities triggered by automatic scaling rules will not
// cause an instance group to grow above or below these limits.
type ScalingConstraints struct {
	_ struct{} `type:"structure"`

	// The upper boundary of EC2 instances in an instance group beyond which scaling
	// activities are not allowed to grow. Scale-out activities will not add instances
	// beyond this boundary.
	//
	// MaxCapacity is a required field
	MaxCapacity *int64 `type:"integer" required:"true"`

	// The lower boundary of EC2 instances in an instance group below which scaling
	// activities are not allowed to shrink. Scale-in activities will not terminate
	// instances below this boundary.
	//
	// MinCapacity is a required field
	MinCapacity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ScalingConstraints) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingConstraints) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScalingConstraints"}

	if s.MaxCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxCapacity"))
	}

	if s.MinCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A scale-in or scale-out rule that defines scaling activity, including the
// CloudWatch metric alarm that triggers activity, how EC2 instances are added
// or removed, and the periodicity of adjustments. The automatic scaling policy
// for an instance group can comprise one or more automatic scaling rules.
type ScalingRule struct {
	_ struct{} `type:"structure"`

	// The conditions that trigger an automatic scaling activity.
	//
	// Action is a required field
	Action *ScalingAction `type:"structure" required:"true"`

	// A friendly, more verbose description of the automatic scaling rule.
	Description *string `type:"string"`

	// The name used to identify an automatic scaling rule. Rule names must be unique
	// within a scaling policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The CloudWatch alarm definition that determines when automatic scaling activity
	// is triggered.
	//
	// Trigger is a required field
	Trigger *ScalingTrigger `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScalingRule"}

	if s.Action == nil {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Trigger == nil {
		invalidParams.Add(aws.NewErrParamRequired("Trigger"))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(aws.ErrInvalidParams))
		}
	}
	if s.Trigger != nil {
		if err := s.Trigger.Validate(); err != nil {
			invalidParams.AddNested("Trigger", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The conditions that trigger an automatic scaling activity.
type ScalingTrigger struct {
	_ struct{} `type:"structure"`

	// The definition of a CloudWatch metric alarm. When the defined alarm conditions
	// are met along with other trigger parameters, scaling activity begins.
	//
	// CloudWatchAlarmDefinition is a required field
	CloudWatchAlarmDefinition *CloudWatchAlarmDefinition `type:"structure" required:"true"`
}

// String returns the string representation
func (s ScalingTrigger) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScalingTrigger"}

	if s.CloudWatchAlarmDefinition == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchAlarmDefinition"))
	}
	if s.CloudWatchAlarmDefinition != nil {
		if err := s.CloudWatchAlarmDefinition.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchAlarmDefinition", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Configuration of the script to run during a bootstrap action.
type ScriptBootstrapActionConfig struct {
	_ struct{} `type:"structure"`

	// A list of command line arguments to pass to the bootstrap action script.
	Args []string `type:"list"`

	// Location of the script to run during a bootstrap action. Can be either a
	// location in Amazon S3 or on a local file system.
	//
	// Path is a required field
	Path *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ScriptBootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScriptBootstrapActionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ScriptBootstrapActionConfig"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The creation date and time, and name, of a security configuration.
type SecurityConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the security configuration was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The name of the security configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SecurityConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// Policy for customizing shrink operations. Allows configuration of decommissioning
// timeout and targeted instance shrinking.
type ShrinkPolicy struct {
	_ struct{} `type:"structure"`

	// The desired timeout for decommissioning an instance. Overrides the default
	// YARN decommissioning timeout.
	DecommissionTimeout *int64 `type:"integer"`

	// Custom policy for requesting termination protection or termination of specific
	// instances when shrinking an instance group.
	InstanceResizePolicy *InstanceResizePolicy `type:"structure"`
}

// String returns the string representation
func (s ShrinkPolicy) String() string {
	return awsutil.Prettify(s)
}

// An automatic scaling configuration, which describes how the policy adds or
// removes instances, the cooldown period, and the number of EC2 instances that
// will be added each time the CloudWatch metric alarm condition is satisfied.
type SimpleScalingPolicyConfiguration struct {
	_ struct{} `type:"structure"`

	// The way in which EC2 instances are added (if ScalingAdjustment is a positive
	// number) or terminated (if ScalingAdjustment is a negative number) each time
	// the scaling activity is triggered. CHANGE_IN_CAPACITY is the default. CHANGE_IN_CAPACITY
	// indicates that the EC2 instance count increments or decrements by ScalingAdjustment,
	// which should be expressed as an integer. PERCENT_CHANGE_IN_CAPACITY indicates
	// the instance count increments or decrements by the percentage specified by
	// ScalingAdjustment, which should be expressed as an integer. For example,
	// 20 indicates an increase in 20% increments of cluster capacity. EXACT_CAPACITY
	// indicates the scaling activity results in an instance group with the number
	// of EC2 instances specified by ScalingAdjustment, which should be expressed
	// as a positive integer.
	AdjustmentType AdjustmentType `type:"string" enum:"true"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further trigger-related scaling activities can start. The default value
	// is 0.
	CoolDown *int64 `type:"integer"`

	// The amount by which to scale in or scale out, based on the specified AdjustmentType.
	// A positive value adds to the instance group's EC2 instance count while a
	// negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY,
	// the number should only be a positive integer. If AdjustmentType is set to
	// PERCENT_CHANGE_IN_CAPACITY, the value should express the percentage as an
	// integer. For example, -20 indicates a decrease in 20% increments of cluster
	// capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SimpleScalingPolicyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimpleScalingPolicyConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SimpleScalingPolicyConfiguration"}

	if s.ScalingAdjustment == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The launch specification for Spot instances in the instance fleet, which
// determines the defined duration, provisioning timeout behavior, and allocation
// strategy.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions. Spot instance allocation strategy
// is available in Amazon EMR version 5.12.1 and later.
type SpotProvisioningSpecification struct {
	_ struct{} `type:"structure"`

	// Specifies the strategy to use in launching Spot instance fleets. Currently,
	// the only option is capacity-optimized (the default), which launches instances
	// from Spot instance pools with optimal capacity for the number of instances
	// that are launching.
	AllocationStrategy SpotProvisioningAllocationStrategy `type:"string" enum:"true"`

	// The defined duration for Spot instances (also known as Spot blocks) in minutes.
	// When specified, the Spot instance does not terminate before the defined duration
	// expires, and defined duration pricing for Spot instances applies. Valid values
	// are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as
	// a Spot instance receives its instance ID. At the end of the duration, Amazon
	// EC2 marks the Spot instance for termination and provides a Spot instance
	// termination notice, which gives the instance a two-minute warning before
	// it terminates.
	BlockDurationMinutes *int64 `type:"integer"`

	// The action to take when TargetSpotCapacity has not been fulfilled when the
	// TimeoutDurationMinutes has expired; that is, when all Spot instances could
	// not be provisioned within the Spot provisioning timeout. Valid values are
	// TERMINATE_CLUSTER and SWITCH_TO_ON_DEMAND. SWITCH_TO_ON_DEMAND specifies
	// that if no Spot instances are available, On-Demand Instances should be provisioned
	// to fulfill any remaining Spot capacity.
	//
	// TimeoutAction is a required field
	TimeoutAction SpotProvisioningTimeoutAction `type:"string" required:"true" enum:"true"`

	// The spot provisioning timeout period in minutes. If Spot instances are not
	// provisioned within this time period, the TimeOutAction is taken. Minimum
	// value is 5 and maximum value is 1440. The timeout applies only during initial
	// provisioning, when the cluster is first created.
	//
	// TimeoutDurationMinutes is a required field
	TimeoutDurationMinutes *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s SpotProvisioningSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpotProvisioningSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SpotProvisioningSpecification"}
	if len(s.TimeoutAction) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TimeoutAction"))
	}

	if s.TimeoutDurationMinutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeoutDurationMinutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// This represents a step in a cluster.
type Step struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure ActionOnFailure `type:"string" enum:"true"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// Specification of a cluster (job flow) step.
type StepConfig struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is provided for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure ActionOnFailure `type:"string" enum:"true"`

	// The JAR file used for the step.
	//
	// HadoopJarStep is a required field
	HadoopJarStep *HadoopJarStepConfig `type:"structure" required:"true"`

	// The name of the step.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StepConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StepConfig"}

	if s.HadoopJarStep == nil {
		invalidParams.Add(aws.NewErrParamRequired("HadoopJarStep"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.HadoopJarStep != nil {
		if err := s.HadoopJarStep.Validate(); err != nil {
			invalidParams.AddNested("HadoopJarStep", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Combines the execution state and configuration of a step.
type StepDetail struct {
	_ struct{} `type:"structure"`

	// The description of the step status.
	//
	// ExecutionStatusDetail is a required field
	ExecutionStatusDetail *StepExecutionStatusDetail `type:"structure" required:"true"`

	// The step configuration.
	//
	// StepConfig is a required field
	StepConfig *StepConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StepDetail) String() string {
	return awsutil.Prettify(s)
}

// The execution state of a step.
type StepExecutionStatusDetail struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the step.
	//
	// CreationDateTime is a required field
	CreationDateTime *time.Time `type:"timestamp" required:"true"`

	// The completion date and time of the step.
	EndDateTime *time.Time `type:"timestamp"`

	// A description of the step's current state.
	LastStateChangeReason *string `type:"string"`

	// The start date and time of the step.
	StartDateTime *time.Time `type:"timestamp"`

	// The state of the step.
	//
	// State is a required field
	State StepExecutionState `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s StepExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// The details of the step state change reason.
type StepStateChangeReason struct {
	_ struct{} `type:"structure"`

	// The programmable code for the state change reason. Note: Currently, the service
	// provides no code for the state change.
	Code StepStateChangeReasonCode `type:"string" enum:"true"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`
}

// String returns the string representation
func (s StepStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// The execution status details of the cluster step.
type StepStatus struct {
	_ struct{} `type:"structure"`

	// The details for the step failure including reason, message, and log file
	// path where the root cause was identified.
	FailureDetails *FailureDetails `type:"structure"`

	// The execution state of the cluster step.
	State StepState `type:"string" enum:"true"`

	// The reason for the step execution status change.
	StateChangeReason *StepStateChangeReason `type:"structure"`

	// The timeline of the cluster step status over time.
	Timeline *StepTimeline `type:"structure"`
}

// String returns the string representation
func (s StepStatus) String() string {
	return awsutil.Prettify(s)
}

// The summary of the cluster step.
type StepSummary struct {
	_ struct{} `type:"structure"`

	// The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER,
	// CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward
	// compatibility. We recommend using TERMINATE_CLUSTER instead.
	ActionOnFailure ActionOnFailure `type:"string" enum:"true"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`
}

// String returns the string representation
func (s StepSummary) String() string {
	return awsutil.Prettify(s)
}

// The timeline of the cluster step lifecycle.
type StepTimeline struct {
	_ struct{} `type:"structure"`

	// The date and time when the cluster step was created.
	CreationDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster step execution completed or failed.
	EndDateTime *time.Time `type:"timestamp"`

	// The date and time when the cluster step execution started.
	StartDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s StepTimeline) String() string {
	return awsutil.Prettify(s)
}

// The list of supported product configurations which allow user-supplied arguments.
// EMR accepts these arguments and forwards them to the corresponding installation
// script as bootstrap action arguments.
type SupportedProductConfig struct {
	_ struct{} `type:"structure"`

	// The list of user-supplied arguments.
	Args []string `type:"list"`

	// The name of the product configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s SupportedProductConfig) String() string {
	return awsutil.Prettify(s)
}

// A key/value pair containing user-defined metadata that you can associate
// with an Amazon EMR resource. Tags make it easier to associate clusters in
// various ways, such as grouping clusters to track your Amazon EMR resource
// allocation costs. For more information, see Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// A user-defined key, which is the minimum required information for a valid
	// tag. For more information, see Tag (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
	Key *string `type:"string"`

	// A user-defined value, which is optional in a tag. For more information, see
	// Tag Clusters (https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// EBS volume specifications such as volume type, IOPS, and size (GiB) that
// will be requested for the EBS volume attached to an EC2 instance in the cluster.
type VolumeSpecification struct {
	_ struct{} `type:"structure"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	Iops *int64 `type:"integer"`

	// The volume size, in gibibytes (GiB). This can be a number from 1 - 1024.
	// If the volume type is EBS-optimized, the minimum value is 10.
	//
	// SizeInGB is a required field
	SizeInGB *int64 `type:"integer" required:"true"`

	// The volume type. Volume types supported are gp2, io1, standard.
	//
	// VolumeType is a required field
	VolumeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VolumeSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VolumeSpecification"}

	if s.SizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("SizeInGB"))
	}

	if s.VolumeType == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
