// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eventbridge

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The entry that defines an event in your system. You can specify several parameters
	// for the entry such as the source and type of the event, resources associated
	// with the event, and so on.
	//
	// Entries is a required field
	Entries []PutEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventsInput"}

	if s.Entries == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutEventsOutput struct {
	_ struct{} `type:"structure"`

	// The successfully and unsuccessfully ingested events results. If the ingestion
	// was successful, the entry has the event ID in it. Otherwise, you can use
	// the error code and error message to identify the problem with the entry.
	Entries []PutEventsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutEvents = "PutEvents"

// PutEventsRequest returns a request value for making API operation for
// Amazon EventBridge.
//
// Sends custom events to Amazon EventBridge so that they can be matched to
// rules.
//
//    // Example sending a request using PutEventsRequest.
//    req := client.PutEventsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutEvents
func (c *Client) PutEventsRequest(input *PutEventsInput) PutEventsRequest {
	op := &aws.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	req := c.newRequest(op, input, &PutEventsOutput{})

	return PutEventsRequest{Request: req, Input: input, Copy: c.PutEventsRequest}
}

// PutEventsRequest is the request type for the
// PutEvents API operation.
type PutEventsRequest struct {
	*aws.Request
	Input *PutEventsInput
	Copy  func(*PutEventsInput) PutEventsRequest
}

// Send marshals and sends the PutEvents API request.
func (r PutEventsRequest) Send(ctx context.Context) (*PutEventsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventsResponse{
		PutEventsOutput: r.Request.Data.(*PutEventsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventsResponse is the response type for the
// PutEvents API operation.
type PutEventsResponse struct {
	*PutEventsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEvents request.
func (r *PutEventsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
