// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// Set this to true if you want to delete the delivery stream even if Kinesis
	// Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose
	// might be unable to retire the grant due to a customer error, such as when
	// the CMK or the grant are in an invalid state. If you force deletion, you
	// can then use the RevokeGrant (https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
	// operation to revoke the grant you gave to Kinesis Data Firehose. If a failure
	// to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose
	// keeps retrying the delete operation.
	//
	// The default value is false.
	AllowForceDelete *bool `type:"boolean"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeliveryStreamInput"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDeliveryStream = "DeleteDeliveryStream"

// DeleteDeliveryStreamRequest returns a request value for making API operation for
// Amazon Kinesis Firehose.
//
// Deletes a delivery stream and its data.
//
// To check the state of a delivery stream, use DescribeDeliveryStream. You
// can delete a delivery stream only if it is in one of the following states:
// ACTIVE, DELETING, CREATING_FAILED, or DELETING_FAILED. You can't delete a
// delivery stream that is in the CREATING state. While the deletion request
// is in process, the delivery stream is in the DELETING state.
//
// While the delivery stream is in the DELETING state, the service might continue
// to accept records, but it doesn't make any guarantees with respect to delivering
// the data. Therefore, as a best practice, first stop any applications that
// are sending records before you delete a delivery stream.
//
//    // Example sending a request using DeleteDeliveryStreamRequest.
//    req := client.DeleteDeliveryStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Client) DeleteDeliveryStreamRequest(input *DeleteDeliveryStreamInput) DeleteDeliveryStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteDeliveryStreamOutput{})

	return DeleteDeliveryStreamRequest{Request: req, Input: input, Copy: c.DeleteDeliveryStreamRequest}
}

// DeleteDeliveryStreamRequest is the request type for the
// DeleteDeliveryStream API operation.
type DeleteDeliveryStreamRequest struct {
	*aws.Request
	Input *DeleteDeliveryStreamInput
	Copy  func(*DeleteDeliveryStreamInput) DeleteDeliveryStreamRequest
}

// Send marshals and sends the DeleteDeliveryStream API request.
func (r DeleteDeliveryStreamRequest) Send(ctx context.Context) (*DeleteDeliveryStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeliveryStreamResponse{
		DeleteDeliveryStreamOutput: r.Request.Data.(*DeleteDeliveryStreamOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeliveryStreamResponse is the response type for the
// DeleteDeliveryStream API operation.
type DeleteDeliveryStreamResponse struct {
	*DeleteDeliveryStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDeliveryStream request.
func (r *DeleteDeliveryStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
