// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteAppsListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the applications list that you want to delete. You can retrieve
	// this ID from PutAppsList, ListAppsLists, and GetAppsList.
	//
	// ListId is a required field
	ListId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppsListInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppsListInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAppsListInput"}

	if s.ListId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListId"))
	}
	if s.ListId != nil && len(*s.ListId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ListId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAppsListOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppsListOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAppsList = "DeleteAppsList"

// DeleteAppsListRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Permanently deletes an AWS Firewall Manager applications list.
//
//    // Example sending a request using DeleteAppsListRequest.
//    req := client.DeleteAppsListRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteAppsList
func (c *Client) DeleteAppsListRequest(input *DeleteAppsListInput) DeleteAppsListRequest {
	op := &aws.Operation{
		Name:       opDeleteAppsList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppsListInput{}
	}

	req := c.newRequest(op, input, &DeleteAppsListOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteAppsListRequest{Request: req, Input: input, Copy: c.DeleteAppsListRequest}
}

// DeleteAppsListRequest is the request type for the
// DeleteAppsList API operation.
type DeleteAppsListRequest struct {
	*aws.Request
	Input *DeleteAppsListInput
	Copy  func(*DeleteAppsListInput) DeleteAppsListRequest
}

// Send marshals and sends the DeleteAppsList API request.
func (r DeleteAppsListRequest) Send(ctx context.Context) (*DeleteAppsListResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAppsListResponse{
		DeleteAppsListOutput: r.Request.Data.(*DeleteAppsListOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAppsListResponse is the response type for the
// DeleteAppsList API operation.
type DeleteAppsListResponse struct {
	*DeleteAppsListOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAppsList request.
func (r *DeleteAppsListResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
