// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeleteNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

type DeleteNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNotificationChannel = "DeleteNotificationChannel"

// DeleteNotificationChannelRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Deletes an AWS Firewall Manager association with the IAM role and the Amazon
// Simple Notification Service (SNS) topic that is used to record AWS Firewall
// Manager SNS logs.
//
//    // Example sending a request using DeleteNotificationChannelRequest.
//    req := client.DeleteNotificationChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel
func (c *Client) DeleteNotificationChannelRequest(input *DeleteNotificationChannelInput) DeleteNotificationChannelRequest {
	op := &aws.Operation{
		Name:       opDeleteNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationChannelInput{}
	}

	req := c.newRequest(op, input, &DeleteNotificationChannelOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteNotificationChannelRequest{Request: req, Input: input, Copy: c.DeleteNotificationChannelRequest}
}

// DeleteNotificationChannelRequest is the request type for the
// DeleteNotificationChannel API operation.
type DeleteNotificationChannelRequest struct {
	*aws.Request
	Input *DeleteNotificationChannelInput
	Copy  func(*DeleteNotificationChannelInput) DeleteNotificationChannelRequest
}

// Send marshals and sends the DeleteNotificationChannel API request.
func (r DeleteNotificationChannelRequest) Send(ctx context.Context) (*DeleteNotificationChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNotificationChannelResponse{
		DeleteNotificationChannelOutput: r.Request.Data.(*DeleteNotificationChannelOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNotificationChannelResponse is the response type for the
// DeleteNotificationChannel API operation.
type DeleteNotificationChannelResponse struct {
	*DeleteNotificationChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNotificationChannel request.
func (r *DeleteNotificationChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
