// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetComplianceDetailInput struct {
	_ struct{} `type:"structure"`

	// The AWS account that owns the resources that you want to get the details
	// for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the policy that you want to get the details for. PolicyId is returned
	// by PutPolicy and by ListPolicies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetComplianceDetailInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComplianceDetailInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetComplianceDetailInput"}

	if s.MemberAccount == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberAccount"))
	}
	if s.MemberAccount != nil && len(*s.MemberAccount) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MemberAccount", 1))
	}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetComplianceDetailOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resources and the policy that you specified in the
	// GetComplianceDetail request.
	PolicyComplianceDetail *PolicyComplianceDetail `type:"structure"`
}

// String returns the string representation
func (s GetComplianceDetailOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetComplianceDetail = "GetComplianceDetail"

// GetComplianceDetailRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Returns detailed compliance information about the specified member account.
// Details include resources that are in and out of compliance with the specified
// policy. Resources are considered noncompliant for AWS WAF and Shield Advanced
// policies if the specified policy has not been applied to them. Resources
// are considered noncompliant for security group policies if they are in scope
// of the policy, they violate one or more of the policy rules, and remediation
// is disabled or not possible.
//
//    // Example sending a request using GetComplianceDetailRequest.
//    req := client.GetComplianceDetailRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail
func (c *Client) GetComplianceDetailRequest(input *GetComplianceDetailInput) GetComplianceDetailRequest {
	op := &aws.Operation{
		Name:       opGetComplianceDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComplianceDetailInput{}
	}

	req := c.newRequest(op, input, &GetComplianceDetailOutput{})

	return GetComplianceDetailRequest{Request: req, Input: input, Copy: c.GetComplianceDetailRequest}
}

// GetComplianceDetailRequest is the request type for the
// GetComplianceDetail API operation.
type GetComplianceDetailRequest struct {
	*aws.Request
	Input *GetComplianceDetailInput
	Copy  func(*GetComplianceDetailInput) GetComplianceDetailRequest
}

// Send marshals and sends the GetComplianceDetail API request.
func (r GetComplianceDetailRequest) Send(ctx context.Context) (*GetComplianceDetailResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetComplianceDetailResponse{
		GetComplianceDetailOutput: r.Request.Data.(*GetComplianceDetailOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetComplianceDetailResponse is the response type for the
// GetComplianceDetail API operation.
type GetComplianceDetailResponse struct {
	*GetComplianceDetailOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetComplianceDetail request.
func (r *GetComplianceDetailResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
