// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetNotificationChannelInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

type GetNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The IAM role that is used by AWS Firewall Manager to record activity to SNS.
	SnsRoleName *string `min:"1" type:"string"`

	// The SNS topic that records AWS Firewall Manager activity.
	SnsTopicArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetNotificationChannel = "GetNotificationChannel"

// GetNotificationChannelRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Information about the Amazon Simple Notification Service (SNS) topic that
// is used to record AWS Firewall Manager SNS logs.
//
//    // Example sending a request using GetNotificationChannelRequest.
//    req := client.GetNotificationChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel
func (c *Client) GetNotificationChannelRequest(input *GetNotificationChannelInput) GetNotificationChannelRequest {
	op := &aws.Operation{
		Name:       opGetNotificationChannel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNotificationChannelInput{}
	}

	req := c.newRequest(op, input, &GetNotificationChannelOutput{})

	return GetNotificationChannelRequest{Request: req, Input: input, Copy: c.GetNotificationChannelRequest}
}

// GetNotificationChannelRequest is the request type for the
// GetNotificationChannel API operation.
type GetNotificationChannelRequest struct {
	*aws.Request
	Input *GetNotificationChannelInput
	Copy  func(*GetNotificationChannelInput) GetNotificationChannelRequest
}

// Send marshals and sends the GetNotificationChannel API request.
func (r GetNotificationChannelRequest) Send(ctx context.Context) (*GetNotificationChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetNotificationChannelResponse{
		GetNotificationChannelOutput: r.Request.Data.(*GetNotificationChannelOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetNotificationChannelResponse is the response type for the
// GetNotificationChannel API operation.
type GetNotificationChannelResponse struct {
	*GetNotificationChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetNotificationChannel request.
func (r *GetNotificationChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
