// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Firewall Manager policy that you want the details for.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPolicyInput"}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified AWS Firewall Manager policy.
	Policy *Policy `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Returns information about the specified AWS Firewall Manager policy.
//
//    // Example sending a request using GetPolicyRequest.
//    req := client.GetPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy
func (c *Client) GetPolicyRequest(input *GetPolicyInput) GetPolicyRequest {
	op := &aws.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req := c.newRequest(op, input, &GetPolicyOutput{})

	return GetPolicyRequest{Request: req, Input: input, Copy: c.GetPolicyRequest}
}

// GetPolicyRequest is the request type for the
// GetPolicy API operation.
type GetPolicyRequest struct {
	*aws.Request
	Input *GetPolicyInput
	Copy  func(*GetPolicyInput) GetPolicyRequest
}

// Send marshals and sends the GetPolicy API request.
func (r GetPolicyRequest) Send(ctx context.Context) (*GetPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPolicyResponse{
		GetPolicyOutput: r.Request.Data.(*GetPolicyOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPolicyResponse is the response type for the
// GetPolicy API operation.
type GetPolicyResponse struct {
	*GetPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPolicy request.
func (r *GetPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
