// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetViolationDetailsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account ID that you want the details for.
	//
	// MemberAccount is a required field
	MemberAccount *string `min:"1" type:"string" required:"true"`

	// The ID of the AWS Firewall Manager policy that you want the details for.
	// This currently only supports security group content audit policies.
	//
	// PolicyId is a required field
	PolicyId *string `min:"36" type:"string" required:"true"`

	// The ID of the resource that has violations.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The resource type. This is in the format shown in the AWS Resource Types
	// Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// Supported resource types are: AWS::EC2::Instance, AWS::EC2::NetworkInterface,
	// or AWS::EC2::SecurityGroup.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetViolationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetViolationDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetViolationDetailsInput"}

	if s.MemberAccount == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberAccount"))
	}
	if s.MemberAccount != nil && len(*s.MemberAccount) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MemberAccount", 1))
	}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyId", 36))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if s.ResourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetViolationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Violation detail for a resource.
	ViolationDetail *ViolationDetail `type:"structure"`
}

// String returns the string representation
func (s GetViolationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetViolationDetails = "GetViolationDetails"

// GetViolationDetailsRequest returns a request value for making API operation for
// Firewall Management Service.
//
// Retrieves violations for a resource based on the specified AWS Firewall Manager
// policy and AWS account.
//
//    // Example sending a request using GetViolationDetailsRequest.
//    req := client.GetViolationDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetViolationDetails
func (c *Client) GetViolationDetailsRequest(input *GetViolationDetailsInput) GetViolationDetailsRequest {
	op := &aws.Operation{
		Name:       opGetViolationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetViolationDetailsInput{}
	}

	req := c.newRequest(op, input, &GetViolationDetailsOutput{})

	return GetViolationDetailsRequest{Request: req, Input: input, Copy: c.GetViolationDetailsRequest}
}

// GetViolationDetailsRequest is the request type for the
// GetViolationDetails API operation.
type GetViolationDetailsRequest struct {
	*aws.Request
	Input *GetViolationDetailsInput
	Copy  func(*GetViolationDetailsInput) GetViolationDetailsRequest
}

// Send marshals and sends the GetViolationDetails API request.
func (r GetViolationDetailsRequest) Send(ctx context.Context) (*GetViolationDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetViolationDetailsResponse{
		GetViolationDetailsOutput: r.Request.Data.(*GetViolationDetailsOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetViolationDetailsResponse is the response type for the
// GetViolationDetails API operation.
type GetViolationDetailsResponse struct {
	*GetViolationDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetViolationDetails request.
func (r *GetViolationDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
