// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// An array of Amazon Resource Names (ARNs) of the datasets that you want to
	// include in the dataset group.
	DatasetArns []string `type:"list"`

	// A name for the dataset group.
	//
	// DatasetGroupName is a required field
	DatasetGroupName *string `min:"1" type:"string" required:"true"`

	// The domain associated with the dataset group. When you add a dataset to a
	// dataset group, this value and the value specified for the Domain parameter
	// of the CreateDataset operation must match.
	//
	// The Domain and DatasetType that you choose determine the fields that must
	// be present in training data that you import to a dataset. For example, if
	// you choose the RETAIL domain and TARGET_TIME_SERIES as the DatasetType, Amazon
	// Forecast requires that item_id, timestamp, and demand fields are present
	// in your data. For more information, see howitworks-datasets-groups.
	//
	// Domain is a required field
	Domain Domain `type:"string" required:"true" enum:"true"`

	// The optional metadata that you apply to the dataset group to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Forecast considers
	//    it to be a user tag and will count against the limit of 50 tags. Tags
	//    with only the key prefix of aws do not count against your tags per resource
	//    limit.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDatasetGroupInput"}

	if s.DatasetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupName"))
	}
	if s.DatasetGroupName != nil && len(*s.DatasetGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatasetGroupName", 1))
	}
	if len(s.Domain) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDatasetGroup = "CreateDatasetGroup"

// CreateDatasetGroupRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Creates a dataset group, which holds a collection of related datasets. You
// can add datasets to the dataset group when you create the dataset group,
// or later by using the UpdateDatasetGroup operation.
//
// After creating a dataset group and adding datasets, you use the dataset group
// when you create a predictor. For more information, see howitworks-datasets-groups.
//
// To get a list of all your datasets groups, use the ListDatasetGroups operation.
//
// The Status of a dataset group must be ACTIVE before you can create use the
// dataset group to create a predictor. To get the status, use the DescribeDatasetGroup
// operation.
//
//    // Example sending a request using CreateDatasetGroupRequest.
//    req := client.CreateDatasetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/CreateDatasetGroup
func (c *Client) CreateDatasetGroupRequest(input *CreateDatasetGroupInput) CreateDatasetGroupRequest {
	op := &aws.Operation{
		Name:       opCreateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetGroupInput{}
	}

	req := c.newRequest(op, input, &CreateDatasetGroupOutput{})

	return CreateDatasetGroupRequest{Request: req, Input: input, Copy: c.CreateDatasetGroupRequest}
}

// CreateDatasetGroupRequest is the request type for the
// CreateDatasetGroup API operation.
type CreateDatasetGroupRequest struct {
	*aws.Request
	Input *CreateDatasetGroupInput
	Copy  func(*CreateDatasetGroupInput) CreateDatasetGroupRequest
}

// Send marshals and sends the CreateDatasetGroup API request.
func (r CreateDatasetGroupRequest) Send(ctx context.Context) (*CreateDatasetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDatasetGroupResponse{
		CreateDatasetGroupOutput: r.Request.Data.(*CreateDatasetGroupOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDatasetGroupResponse is the response type for the
// CreateDatasetGroup API operation.
type CreateDatasetGroupResponse struct {
	*CreateDatasetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDatasetGroup request.
func (r *CreateDatasetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
