// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListForecastsInput struct {
	_ struct{} `type:"structure"`

	// An array of filters. For each filter, you provide a condition and a match
	// statement. The condition is either IS or IS_NOT, which specifies whether
	// to include or exclude the forecasts that match the statement from the list,
	// respectively. The match statement consists of a key and a value.
	//
	// Filter properties
	//
	//    * Condition - The condition to apply. Valid values are IS and IS_NOT.
	//    To include the forecasts that match the statement, specify IS. To exclude
	//    matching forecasts, specify IS_NOT.
	//
	//    * Key - The name of the parameter to filter on. Valid values are DatasetGroupArn,
	//    PredictorArn, and Status.
	//
	//    * Value - The value to match.
	//
	// For example, to list all forecasts whose status is not ACTIVE, you would
	// specify:
	//
	// "Filters": [ { "Condition": "IS_NOT", "Key": "Status", "Value": "ACTIVE"
	// } ]
	Filters []Filter `type:"list"`

	// The number of items to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request was truncated, the response includes
	// a NextToken. To retrieve the next set of results, use the token in the next
	// request. Tokens expire after 24 hours.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListForecastsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListForecastsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListForecastsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that summarize each forecast's properties.
	Forecasts []ForecastSummary `type:"list"`

	// If the response is truncated, Amazon Forecast returns this token. To retrieve
	// the next set of results, use the token in the next request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListForecastsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListForecasts = "ListForecasts"

// ListForecastsRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Returns a list of forecasts created using the CreateForecast operation. For
// each forecast, this operation returns a summary of its properties, including
// its Amazon Resource Name (ARN). To retrieve the complete set of properties,
// specify the ARN with the DescribeForecast operation. You can filter the list
// using an array of Filter objects.
//
//    // Example sending a request using ListForecastsRequest.
//    req := client.ListForecastsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/ListForecasts
func (c *Client) ListForecastsRequest(input *ListForecastsInput) ListForecastsRequest {
	op := &aws.Operation{
		Name:       opListForecasts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListForecastsInput{}
	}

	req := c.newRequest(op, input, &ListForecastsOutput{})

	return ListForecastsRequest{Request: req, Input: input, Copy: c.ListForecastsRequest}
}

// ListForecastsRequest is the request type for the
// ListForecasts API operation.
type ListForecastsRequest struct {
	*aws.Request
	Input *ListForecastsInput
	Copy  func(*ListForecastsInput) ListForecastsRequest
}

// Send marshals and sends the ListForecasts API request.
func (r ListForecastsRequest) Send(ctx context.Context) (*ListForecastsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListForecastsResponse{
		ListForecastsOutput: r.Request.Data.(*ListForecastsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListForecastsRequestPaginator returns a paginator for ListForecasts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListForecastsRequest(input)
//   p := forecast.NewListForecastsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListForecastsPaginator(req ListForecastsRequest) ListForecastsPaginator {
	return ListForecastsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListForecastsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListForecastsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListForecastsPaginator struct {
	aws.Pager
}

func (p *ListForecastsPaginator) CurrentPage() *ListForecastsOutput {
	return p.Pager.CurrentPage().(*ListForecastsOutput)
}

// ListForecastsResponse is the response type for the
// ListForecasts API operation.
type ListForecastsResponse struct {
	*ListForecastsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListForecasts request.
func (r *ListForecastsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
