// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDatasetGroupInput struct {
	_ struct{} `type:"structure"`

	// An array of the Amazon Resource Names (ARNs) of the datasets to add to the
	// dataset group.
	//
	// DatasetArns is a required field
	DatasetArns []string `type:"list" required:"true"`

	// The ARN of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDatasetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDatasetGroupInput"}

	if s.DatasetArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetArns"))
	}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDatasetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDatasetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDatasetGroup = "UpdateDatasetGroup"

// UpdateDatasetGroupRequest returns a request value for making API operation for
// Amazon Forecast Service.
//
// Replaces the datasets in a dataset group with the specified datasets.
//
// The Status of the dataset group must be ACTIVE before you can use the dataset
// group to create a predictor. Use the DescribeDatasetGroup operation to get
// the status.
//
//    // Example sending a request using UpdateDatasetGroupRequest.
//    req := client.UpdateDatasetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/UpdateDatasetGroup
func (c *Client) UpdateDatasetGroupRequest(input *UpdateDatasetGroupInput) UpdateDatasetGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateDatasetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatasetGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateDatasetGroupOutput{})

	return UpdateDatasetGroupRequest{Request: req, Input: input, Copy: c.UpdateDatasetGroupRequest}
}

// UpdateDatasetGroupRequest is the request type for the
// UpdateDatasetGroup API operation.
type UpdateDatasetGroupRequest struct {
	*aws.Request
	Input *UpdateDatasetGroupInput
	Copy  func(*UpdateDatasetGroupInput) UpdateDatasetGroupRequest
}

// Send marshals and sends the UpdateDatasetGroup API request.
func (r UpdateDatasetGroupRequest) Send(ctx context.Context) (*UpdateDatasetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDatasetGroupResponse{
		UpdateDatasetGroupOutput: r.Request.Data.(*UpdateDatasetGroupOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDatasetGroupResponse is the response type for the
// UpdateDatasetGroup API operation.
type UpdateDatasetGroupResponse struct {
	*UpdateDatasetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDatasetGroup request.
func (r *UpdateDatasetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
