// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package forecast

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Specifies a categorical hyperparameter and it's range of tunable values.
// This object is part of the ParameterRanges object.
type CategoricalParameterRange struct {
	_ struct{} `type:"structure"`

	// The name of the categorical hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of the tunable categories for the hyperparameter.
	//
	// Values is a required field
	Values []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CategoricalParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CategoricalParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CategoricalParameterRange"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a continuous hyperparameter and it's range of tunable values. This
// object is part of the ParameterRanges object.
type ContinuousParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum tunable value of the hyperparameter.
	//
	// MaxValue is a required field
	MaxValue *float64 `type:"double" required:"true"`

	// The minimum tunable value of the hyperparameter.
	//
	// MinValue is a required field
	MinValue *float64 `type:"double" required:"true"`

	// The name of the hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// Valid values:
	//
	// Auto
	//
	// Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have values greater than 0.
	//
	// ReverseLogarithmic
	//
	// hyperparameter tuning searches the values in the hyperparameter range by
	// using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0 <= x < 1.0.
	//
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	ScalingType ScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ContinuousParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinuousParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContinuousParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The destination for an exported forecast, an AWS Identity and Access Management
// (IAM) role that allows Amazon Forecast to access the location and, optionally,
// an AWS Key Management Service (KMS) key. This object is submitted in the
// CreateForecastExportJob request.
type DataDestination struct {
	_ struct{} `type:"structure"`

	// The path to an Amazon Simple Storage Service (Amazon S3) bucket along with
	// the credentials to access the bucket.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`
}

// String returns the string representation
func (s DataDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataDestination"}

	if s.S3Config == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The source of your training data, an AWS Identity and Access Management (IAM)
// role that allows Amazon Forecast to access the data and, optionally, an AWS
// Key Management Service (KMS) key. This object is submitted in the CreateDatasetImportJob
// request.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The path to the training data stored in an Amazon Simple Storage Service
	// (Amazon S3) bucket along with the credentials to access the data.
	//
	// S3Config is a required field
	S3Config *S3Config `type:"structure" required:"true"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataSource"}

	if s.S3Config == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3Config"))
	}
	if s.S3Config != nil {
		if err := s.S3Config.Validate(); err != nil {
			invalidParams.AddNested("S3Config", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of the dataset group properties used in the ListDatasetGroups
// operation. To get the complete set of properties, call the DescribeDatasetGroup
// operation, and provide the DatasetGroupArn.
type DatasetGroupSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset group was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group.
	DatasetGroupArn *string `type:"string"`

	// The name of the dataset group.
	DatasetGroupName *string `min:"1" type:"string"`

	// When the dataset group was created or last updated from a call to the UpdateDatasetGroup
	// operation. While the dataset group is being updated, LastModificationTime
	// is the current time of the ListDatasetGroups call.
	LastModificationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DatasetGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the dataset import job properties used in the ListDatasetImportJobs
// operation. To get the complete set of properties, call the DescribeDatasetImportJob
// operation, and provide the DatasetImportJobArn.
type DatasetImportJobSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset import job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The location of the training data to import and an AWS Identity and Access
	// Management (IAM) role that Amazon Forecast can assume to access the data.
	// The training data must be stored in an Amazon S3 bucket.
	//
	// If encryption is used, DataSource includes an AWS Key Management Service
	// (KMS) key.
	DataSource *DataSource `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset import job.
	DatasetImportJobArn *string `type:"string"`

	// The name of the dataset import job.
	DatasetImportJobName *string `min:"1" type:"string"`

	// The last time that the dataset was modified. The time depends on the status
	// of the job, as follows:
	//
	//    * CREATE_PENDING - The same time as CreationTime.
	//
	//    * CREATE_IN_PROGRESS - The current timestamp.
	//
	//    * ACTIVE or CREATE_FAILED - When the job finished or failed.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the dataset import job. The status is reflected in the status
	// of the dataset. For example, when the import job status is CREATE_IN_PROGRESS,
	// the status of the dataset is UPDATE_IN_PROGRESS. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	Status *string `type:"string"`
}

// String returns the string representation
func (s DatasetImportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the dataset properties used in the ListDatasets operation.
// To get the complete set of properties, call the DescribeDataset operation,
// and provide the DatasetArn.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// When the dataset was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset.
	DatasetArn *string `type:"string"`

	// The name of the dataset.
	DatasetName *string `min:"1" type:"string"`

	// The dataset type.
	DatasetType DatasetType `type:"string" enum:"true"`

	// The domain associated with the dataset.
	Domain Domain `type:"string" enum:"true"`

	// When you create a dataset, LastModificationTime is the same as CreationTime.
	// While data is being imported to the dataset, LastModificationTime is the
	// current time of the ListDatasets call. After a CreateDatasetImportJob operation
	// has finished, LastModificationTime is when the import job completed or failed.
	LastModificationTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// An AWS Key Management Service (KMS) key and an AWS Identity and Access Management
// (IAM) role that Amazon Forecast can assume to access the key. You can specify
// this optional object in the CreateDataset and CreatePredictor requests.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key.
	//
	// KMSKeyArn is a required field
	KMSKeyArn *string `type:"string" required:"true"`

	// The ARN of the IAM role that Amazon Forecast can assume to access the AWS
	// KMS key.
	//
	// Passing a role across AWS accounts is not allowed. If you pass a role that
	// isn't in your account, you get an InvalidInputException error.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionConfig"}

	if s.KMSKeyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("KMSKeyArn"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Parameters that define how to split a dataset into training data and testing
// data, and the number of iterations to perform. These parameters are specified
// in the predefined algorithms but you can override them in the CreatePredictor
// request.
type EvaluationParameters struct {
	_ struct{} `type:"structure"`

	// The point from the end of the dataset where you want to split the data for
	// model training and testing (evaluation). Specify the value as the number
	// of data points. The default is the value of the forecast horizon. BackTestWindowOffset
	// can be used to mimic a past virtual forecast start date. This value must
	// be greater than or equal to the forecast horizon and less than half of the
	// TARGET_TIME_SERIES dataset length.
	//
	// ForecastHorizon <= BackTestWindowOffset < 1/2 * TARGET_TIME_SERIES dataset
	// length
	BackTestWindowOffset *int64 `type:"integer"`

	// The number of times to split the input data. The default is 1. Valid values
	// are 1 through 5.
	NumberOfBacktestWindows *int64 `type:"integer"`
}

// String returns the string representation
func (s EvaluationParameters) String() string {
	return awsutil.Prettify(s)
}

// The results of evaluating an algorithm. Returned as part of the GetAccuracyMetrics
// response.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the algorithm that was evaluated.
	AlgorithmArn *string `type:"string"`

	// The array of test windows used for evaluating the algorithm. The NumberOfBacktestWindows
	// from the EvaluationParameters object determines the number of windows in
	// the array.
	TestWindows []WindowSummary `type:"list"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// Provides featurization (transformation) information for a dataset field.
// This object is part of the FeaturizationConfig object.
//
// For example:
//
// {
//
// "AttributeName": "demand",
//
// FeaturizationPipeline [ {
//
// "FeaturizationMethodName": "filling",
//
// "FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}
//
// } ]
//
// }
type Featurization struct {
	_ struct{} `type:"structure"`

	// The name of the schema attribute that specifies the data field to be featurized.
	// Amazon Forecast supports the target field of the TARGET_TIME_SERIES and the
	// RELATED_TIME_SERIES datasets. For example, for the RETAIL domain, the target
	// is demand, and for the CUSTOM domain, the target is target_value. For more
	// information, see howitworks-missing-values.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// An array of one FeaturizationMethod object that specifies the feature transformation
	// method.
	FeaturizationPipeline []FeaturizationMethod `min:"1" type:"list"`
}

// String returns the string representation
func (s Featurization) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Featurization) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Featurization"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}
	if s.FeaturizationPipeline != nil && len(s.FeaturizationPipeline) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FeaturizationPipeline", 1))
	}
	if s.FeaturizationPipeline != nil {
		for i, v := range s.FeaturizationPipeline {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FeaturizationPipeline", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// In a CreatePredictor operation, the specified algorithm trains a model using
// the specified dataset group. You can optionally tell the operation to modify
// data fields prior to training a model. These modifications are referred to
// as featurization.
//
// You define featurization using the FeaturizationConfig object. You specify
// an array of transformations, one for each field that you want to featurize.
// You then include the FeaturizationConfig object in your CreatePredictor request.
// Amazon Forecast applies the featurization to the TARGET_TIME_SERIES and RELATED_TIME_SERIES
// datasets before model training.
//
// You can create multiple featurization configurations. For example, you might
// call the CreatePredictor operation twice by specifying different featurization
// configurations.
type FeaturizationConfig struct {
	_ struct{} `type:"structure"`

	// An array of featurization (transformation) information for the fields of
	// a dataset.
	Featurizations []Featurization `min:"1" type:"list"`

	// An array of dimension (field) names that specify how to group the generated
	// forecast.
	//
	// For example, suppose that you are generating a forecast for item sales across
	// all of your stores, and your dataset contains a store_id field. If you want
	// the sales forecast for each item by store, you would specify store_id as
	// the dimension.
	//
	// All forecast dimensions specified in the TARGET_TIME_SERIES dataset don't
	// need to be specified in the CreatePredictor request. All forecast dimensions
	// specified in the RELATED_TIME_SERIES dataset must be specified in the CreatePredictor
	// request.
	ForecastDimensions []string `min:"1" type:"list"`

	// The frequency of predictions in a forecast.
	//
	// Valid intervals are Y (Year), M (Month), W (Week), D (Day), H (Hour), 30min
	// (30 minutes), 15min (15 minutes), 10min (10 minutes), 5min (5 minutes), and
	// 1min (1 minute). For example, "Y" indicates every year and "5min" indicates
	// every five minutes.
	//
	// The frequency must be greater than or equal to the TARGET_TIME_SERIES dataset
	// frequency.
	//
	// When a RELATED_TIME_SERIES dataset is provided, the frequency must be equal
	// to the RELATED_TIME_SERIES dataset frequency.
	//
	// ForecastFrequency is a required field
	ForecastFrequency *string `type:"string" required:"true"`
}

// String returns the string representation
func (s FeaturizationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeaturizationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FeaturizationConfig"}
	if s.Featurizations != nil && len(s.Featurizations) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Featurizations", 1))
	}
	if s.ForecastDimensions != nil && len(s.ForecastDimensions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ForecastDimensions", 1))
	}

	if s.ForecastFrequency == nil {
		invalidParams.Add(aws.NewErrParamRequired("ForecastFrequency"))
	}
	if s.Featurizations != nil {
		for i, v := range s.Featurizations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Featurizations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides information about the method that featurizes (transforms) a dataset
// field. The method is part of the FeaturizationPipeline of the Featurization
// object.
//
// The following is an example of how you specify a FeaturizationMethod object.
//
// {
//
// "FeaturizationMethodName": "filling",
//
// "FeaturizationMethodParameters": {"aggregation": "sum", "middlefill": "zero",
// "backfill": "zero"}
//
// }
type FeaturizationMethod struct {
	_ struct{} `type:"structure"`

	// The name of the method. The "filling" method is the only supported method.
	//
	// FeaturizationMethodName is a required field
	FeaturizationMethodName FeaturizationMethodName `type:"string" required:"true" enum:"true"`

	// The method parameters (key-value pairs), which are a map of override parameters.
	// Specify these parameters to override the default values. Related Time Series
	// attributes do not accept aggregation parameters.
	//
	// The following list shows the parameters and their valid values for the "filling"
	// featurization method for a Target Time Series dataset. Bold signifies the
	// default value.
	//
	//    * aggregation: sum, avg, first, min, max
	//
	//    * frontfill: none
	//
	//    * middlefill: zero, nan (not a number), value, median, mean, min, max
	//
	//    * backfill: zero, nan, value, median, mean, min, max
	//
	// The following list shows the parameters and their valid values for a Related
	// Time Series featurization method (there are no defaults):
	//
	//    * middlefill: zero, value, median, mean, min, max
	//
	//    * backfill: zero, value, median, mean, min, max
	//
	//    * futurefill: zero, value, median, mean, min, max
	FeaturizationMethodParameters map[string]string `min:"1" type:"map"`
}

// String returns the string representation
func (s FeaturizationMethod) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeaturizationMethod) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FeaturizationMethod"}
	if len(s.FeaturizationMethodName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("FeaturizationMethodName"))
	}
	if s.FeaturizationMethodParameters != nil && len(s.FeaturizationMethodParameters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FeaturizationMethodParameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a filter for choosing a subset of objects. Each filter consists
// of a condition and a match statement. The condition is either IS or IS_NOT,
// which specifies whether to include or exclude the objects that match the
// statement, respectively. The match statement consists of a key and a value.
type Filter struct {
	_ struct{} `type:"structure"`

	// The condition to apply. To include the objects that match the statement,
	// specify IS. To exclude matching objects, specify IS_NOT.
	//
	// Condition is a required field
	Condition FilterConditionString `type:"string" required:"true" enum:"true"`

	// The name of the parameter to filter on.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value to match.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}
	if len(s.Condition) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Condition"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides a summary of the forecast export job properties used in the ListForecastExportJobs
// operation. To get the complete set of properties, call the DescribeForecastExportJob
// operation, and provide the listed ForecastExportJobArn.
type ForecastExportJobSummary struct {
	_ struct{} `type:"structure"`

	// When the forecast export job was created.
	CreationTime *time.Time `type:"timestamp"`

	// The path to the Amazon Simple Storage Service (Amazon S3) bucket where the
	// forecast is exported.
	Destination *DataDestination `type:"structure"`

	// The Amazon Resource Name (ARN) of the forecast export job.
	ForecastExportJobArn *string `type:"string"`

	// The name of the forecast export job.
	ForecastExportJobName *string `min:"1" type:"string"`

	// When the last successful export job finished.
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The status of the forecast export job. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast export job must be ACTIVE before you can access
	// the forecast in your S3 bucket.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ForecastExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the forecast properties used in the ListForecasts operation.
// To get the complete set of properties, call the DescribeForecast operation,
// and provide the ForecastArn that is listed in the summary.
type ForecastSummary struct {
	_ struct{} `type:"structure"`

	// When the forecast creation task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that provided the data
	// used to train the predictor.
	DatasetGroupArn *string `type:"string"`

	// The ARN of the forecast.
	ForecastArn *string `type:"string"`

	// The name of the forecast.
	ForecastName *string `min:"1" type:"string"`

	// Initially, the same as CreationTime (status is CREATE_PENDING). Updated when
	// inference (creating the forecast) starts (status changed to CREATE_IN_PROGRESS),
	// and when inference is complete (status changed to ACTIVE) or fails (status
	// changed to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The ARN of the predictor used to generate the forecast.
	PredictorArn *string `type:"string"`

	// The status of the forecast. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	// The Status of the forecast must be ACTIVE before you can query or export
	// the forecast.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ForecastSummary) String() string {
	return awsutil.Prettify(s)
}

// Configuration information for a hyperparameter tuning job. You specify this
// object in the CreatePredictor request.
//
// A hyperparameter is a parameter that governs the model training process.
// You set hyperparameters before training starts, unlike model parameters,
// which are determined during training. The values of the hyperparameters effect
// which values are chosen for the model parameters.
//
// In a hyperparameter tuning job, Amazon Forecast chooses the set of hyperparameter
// values that optimize a specified metric. Forecast accomplishes this by running
// many training jobs over a range of hyperparameter values. The optimum set
// of values depends on the algorithm, the training data, and the specified
// metric objective.
type HyperParameterTuningJobConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the ranges of valid values for the hyperparameters.
	ParameterRanges *ParameterRanges `type:"structure"`
}

// String returns the string representation
func (s HyperParameterTuningJobConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HyperParameterTuningJobConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HyperParameterTuningJobConfig"}
	if s.ParameterRanges != nil {
		if err := s.ParameterRanges.Validate(); err != nil {
			invalidParams.AddNested("ParameterRanges", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data used to train a predictor. The data includes a dataset group and
// any supplementary features. You specify this object in the CreatePredictor
// request.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset group.
	//
	// DatasetGroupArn is a required field
	DatasetGroupArn *string `type:"string" required:"true"`

	// An array of supplementary features. The only supported feature is a holiday
	// calendar.
	SupplementaryFeatures []SupplementaryFeature `min:"1" type:"list"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputDataConfig"}

	if s.DatasetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetGroupArn"))
	}
	if s.SupplementaryFeatures != nil && len(s.SupplementaryFeatures) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SupplementaryFeatures", 1))
	}
	if s.SupplementaryFeatures != nil {
		for i, v := range s.SupplementaryFeatures {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SupplementaryFeatures", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an integer hyperparameter and it's range of tunable values. This
// object is part of the ParameterRanges object.
type IntegerParameterRange struct {
	_ struct{} `type:"structure"`

	// The maximum tunable value of the hyperparameter.
	//
	// MaxValue is a required field
	MaxValue *int64 `type:"integer" required:"true"`

	// The minimum tunable value of the hyperparameter.
	//
	// MinValue is a required field
	MinValue *int64 `type:"integer" required:"true"`

	// The name of the hyperparameter to tune.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// Valid values:
	//
	// Auto
	//
	// Amazon Forecast hyperparameter tuning chooses the best scale for the hyperparameter.
	//
	// Linear
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic
	//
	// Hyperparameter tuning searches the values in the hyperparameter range by
	// using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have values greater than 0.
	//
	// ReverseLogarithmic
	//
	// Not supported for IntegerParameterRange.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within
	// the range 0 <= x < 1.0.
	//
	// For information about choosing a hyperparameter scale, see Hyperparameter
	// Scaling (http://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type).
	// One of the following values:
	ScalingType ScalingType `type:"string" enum:"true"`
}

// String returns the string representation
func (s IntegerParameterRange) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntegerParameterRange) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IntegerParameterRange"}

	if s.MaxValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxValue"))
	}

	if s.MinValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("MinValue"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides metrics that are used to evaluate the performance of a predictor.
// This object is part of the WindowSummary object.
type Metrics struct {
	_ struct{} `type:"structure"`

	// The root mean square error (RMSE).
	RMSE *float64 `type:"double"`

	// An array of weighted quantile losses. Quantiles divide a probability distribution
	// into regions of equal probability. The distribution in this case is the loss
	// function.
	WeightedQuantileLosses []WeightedQuantileLoss `type:"list"`
}

// String returns the string representation
func (s Metrics) String() string {
	return awsutil.Prettify(s)
}

// Specifies the categorical, continuous, and integer hyperparameters, and their
// ranges of tunable values. The range of tunable values determines which values
// that a hyperparameter tuning job can choose for the specified hyperparameter.
// This object is part of the HyperParameterTuningJobConfig object.
type ParameterRanges struct {
	_ struct{} `type:"structure"`

	// Specifies the tunable range for each categorical hyperparameter.
	CategoricalParameterRanges []CategoricalParameterRange `min:"1" type:"list"`

	// Specifies the tunable range for each continuous hyperparameter.
	ContinuousParameterRanges []ContinuousParameterRange `min:"1" type:"list"`

	// Specifies the tunable range for each integer hyperparameter.
	IntegerParameterRanges []IntegerParameterRange `min:"1" type:"list"`
}

// String returns the string representation
func (s ParameterRanges) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterRanges) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParameterRanges"}
	if s.CategoricalParameterRanges != nil && len(s.CategoricalParameterRanges) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CategoricalParameterRanges", 1))
	}
	if s.ContinuousParameterRanges != nil && len(s.ContinuousParameterRanges) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContinuousParameterRanges", 1))
	}
	if s.IntegerParameterRanges != nil && len(s.IntegerParameterRanges) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IntegerParameterRanges", 1))
	}
	if s.CategoricalParameterRanges != nil {
		for i, v := range s.CategoricalParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CategoricalParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ContinuousParameterRanges != nil {
		for i, v := range s.ContinuousParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContinuousParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.IntegerParameterRanges != nil {
		for i, v := range s.IntegerParameterRanges {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IntegerParameterRanges", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The algorithm used to perform a backtest and the status of those tests.
type PredictorExecution struct {
	_ struct{} `type:"structure"`

	// The ARN of the algorithm used to test the predictor.
	AlgorithmArn *string `type:"string"`

	// An array of test windows used to evaluate the algorithm. The NumberOfBacktestWindows
	// from the object determines the number of windows in the array.
	TestWindows []TestWindowSummary `type:"list"`
}

// String returns the string representation
func (s PredictorExecution) String() string {
	return awsutil.Prettify(s)
}

// Contains details on the backtests performed to evaluate the accuracy of the
// predictor. The tests are returned in descending order of accuracy, with the
// most accurate backtest appearing first. You specify the number of backtests
// to perform when you call the operation.
type PredictorExecutionDetails struct {
	_ struct{} `type:"structure"`

	// An array of the backtests performed to evaluate the accuracy of the predictor
	// against a particular algorithm. The NumberOfBacktestWindows from the object
	// determines the number of windows in the array.
	PredictorExecutions []PredictorExecution `min:"1" type:"list"`
}

// String returns the string representation
func (s PredictorExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// Provides a summary of the predictor properties that are used in the ListPredictors
// operation. To get the complete set of properties, call the DescribePredictor
// operation, and provide the listed PredictorArn.
type PredictorSummary struct {
	_ struct{} `type:"structure"`

	// When the model training task was created.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the dataset group that contains the data
	// used to train the predictor.
	DatasetGroupArn *string `type:"string"`

	// Initially, the same as CreationTime (status is CREATE_PENDING). Updated when
	// training starts (status changed to CREATE_IN_PROGRESS), and when training
	// is complete (status changed to ACTIVE) or fails (status changed to CREATE_FAILED).
	LastModificationTime *time.Time `type:"timestamp"`

	// If an error occurred, an informational message about the error.
	Message *string `type:"string"`

	// The ARN of the predictor.
	PredictorArn *string `type:"string"`

	// The name of the predictor.
	PredictorName *string `min:"1" type:"string"`

	// The status of the predictor. States include:
	//
	//    * ACTIVE
	//
	//    * CREATE_PENDING, CREATE_IN_PROGRESS, CREATE_FAILED
	//
	//    * DELETE_PENDING, DELETE_IN_PROGRESS, DELETE_FAILED
	//
	//    * UPDATE_PENDING, UPDATE_IN_PROGRESS, UPDATE_FAILED
	//
	// The Status of the predictor must be ACTIVE before you can use the predictor
	// to create a forecast.
	Status *string `type:"string"`
}

// String returns the string representation
func (s PredictorSummary) String() string {
	return awsutil.Prettify(s)
}

// The path to the file(s) in an Amazon Simple Storage Service (Amazon S3) bucket,
// and an AWS Identity and Access Management (IAM) role that Amazon Forecast
// can assume to access the file(s). Optionally, includes an AWS Key Management
// Service (KMS) key. This object is part of the DataSource object that is submitted
// in the CreateDatasetImportJob request, and part of the DataDestination object
// that is submitted in the CreateForecastExportJob request.
type S3Config struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS) key.
	KMSKeyArn *string `type:"string"`

	// The path to an Amazon Simple Storage Service (Amazon S3) bucket or file(s)
	// in an Amazon S3 bucket.
	//
	// Path is a required field
	Path *string `type:"string" required:"true"`

	// The ARN of the AWS Identity and Access Management (IAM) role that Amazon
	// Forecast can assume to access the Amazon S3 bucket or files. If you provide
	// a value for the KMSKeyArn key, the role must allow access to the key.
	//
	// Passing a role across AWS accounts is not allowed. If you pass a role that
	// isn't in your account, you get an InvalidInputException error.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Config) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Config) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Config"}

	if s.Path == nil {
		invalidParams.Add(aws.NewErrParamRequired("Path"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines the fields of a dataset. You specify this object in the CreateDataset
// request.
type Schema struct {
	_ struct{} `type:"structure"`

	// An array of attributes specifying the name and type of each field in a dataset.
	Attributes []SchemaAttribute `min:"1" type:"list"`
}

// String returns the string representation
func (s Schema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Schema"}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An attribute of a schema, which defines a dataset field. A schema attribute
// is required for every field in a dataset. The Schema object contains an array
// of SchemaAttribute objects.
type SchemaAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the dataset field.
	AttributeName *string `min:"1" type:"string"`

	// The data type of the field.
	AttributeType AttributeType `type:"string" enum:"true"`
}

// String returns the string representation
func (s SchemaAttribute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaAttribute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SchemaAttribute"}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides statistics for each data field imported into to an Amazon Forecast
// dataset with the CreateDatasetImportJob operation.
type Statistics struct {
	_ struct{} `type:"structure"`

	// For a numeric field, the average value in the field.
	Avg *float64 `type:"double"`

	// The number of values in the field.
	Count *int64 `type:"integer"`

	// The number of distinct values in the field.
	CountDistinct *int64 `type:"integer"`

	// The number of NAN (not a number) values in the field.
	CountNan *int64 `type:"integer"`

	// The number of null values in the field.
	CountNull *int64 `type:"integer"`

	// For a numeric field, the maximum value in the field.
	Max *string `type:"string"`

	// For a numeric field, the minimum value in the field.
	Min *string `type:"string"`

	// For a numeric field, the standard deviation.
	Stddev *float64 `type:"double"`
}

// String returns the string representation
func (s Statistics) String() string {
	return awsutil.Prettify(s)
}

// Describes a supplementary feature of a dataset group. This object is part
// of the InputDataConfig object.
//
// The only supported feature is a holiday calendar. If you use the calendar,
// all data in the datasets should belong to the same country as the calendar.
// For the holiday calendar data, see the Jollyday (http://jollyday.sourceforge.net/data.html)
// web site.
//
// India and Korea's holidays are not included in the Jollyday library, but
// both are supported by Amazon Forecast. Their holidays are:
//
// "IN" - INDIA
//
//    * JANUARY 26 - REPUBLIC DAY
//
//    * AUGUST 15 - INDEPENDENCE DAY
//
//    * OCTOBER 2 GANDHI'S BIRTHDAY
//
// "KR" - KOREA
//
//    * JANUARY 1 - NEW YEAR
//
//    * MARCH 1 - INDEPENDENCE MOVEMENT DAY
//
//    * MAY 5 - CHILDREN'S DAY
//
//    * JUNE 6 - MEMORIAL DAY
//
//    * AUGUST 15 - LIBERATION DAY
//
//    * OCTOBER 3 - NATIONAL FOUNDATION DAY
//
//    * OCTOBER 9 - HANGEUL DAY
//
//    * DECEMBER 25 - CHRISTMAS DAY
type SupplementaryFeature struct {
	_ struct{} `type:"structure"`

	// The name of the feature. This must be "holiday".
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One of the following 2 letter country codes:
	//
	//    * "AR" - ARGENTINA
	//
	//    * "AT" - AUSTRIA
	//
	//    * "AU" - AUSTRALIA
	//
	//    * "BE" - BELGIUM
	//
	//    * "BR" - BRAZIL
	//
	//    * "CA" - CANADA
	//
	//    * "CN" - CHINA
	//
	//    * "CZ" - CZECH REPUBLIC
	//
	//    * "DK" - DENMARK
	//
	//    * "EC" - ECUADOR
	//
	//    * "FI" - FINLAND
	//
	//    * "FR" - FRANCE
	//
	//    * "DE" - GERMANY
	//
	//    * "HU" - HUNGARY
	//
	//    * "IE" - IRELAND
	//
	//    * "IN" - INDIA
	//
	//    * "IT" - ITALY
	//
	//    * "JP" - JAPAN
	//
	//    * "KR" - KOREA
	//
	//    * "LU" - LUXEMBOURG
	//
	//    * "MX" - MEXICO
	//
	//    * "NL" - NETHERLANDS
	//
	//    * "NO" - NORWAY
	//
	//    * "PL" - POLAND
	//
	//    * "PT" - PORTUGAL
	//
	//    * "RU" - RUSSIA
	//
	//    * "ZA" - SOUTH AFRICA
	//
	//    * "ES" - SPAIN
	//
	//    * "SE" - SWEDEN
	//
	//    * "CH" - SWITZERLAND
	//
	//    * "US" - UNITED STATES
	//
	//    * "UK" - UNITED KINGDOM
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SupplementaryFeature) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SupplementaryFeature) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SupplementaryFeature"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The optional metadata that you apply to a resource to help you categorize
// and organize them. Each tag consists of a key and an optional value, both
// of which you define.
//
// The following basic restrictions apply to tags:
//
//    * Maximum number of tags per resource - 50.
//
//    * For each resource, each tag key must be unique, and each tag key can
//    have only one value.
//
//    * Maximum key length - 128 Unicode characters in UTF-8.
//
//    * Maximum value length - 256 Unicode characters in UTF-8.
//
//    * If your tagging schema is used across multiple services and resources,
//    remember that other services may have restrictions on allowed characters.
//    Generally allowed characters are: letters, numbers, and spaces representable
//    in UTF-8, and the following characters: + - = . _ : / @.
//
//    * Tag keys and values are case sensitive.
//
//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
//    delete tag keys with this prefix. Values can have this prefix. If a tag
//    value has aws as its prefix but the key does not, then Forecast considers
//    it to be a user tag and will count against the limit of 50 tags. Tags
//    with only the key prefix of aws do not count against your tags per resource
//    limit.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that makes up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that makes up a tag. A value acts as
	// a descriptor within a tag category (key).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status, start time, and end time of a backtest, as well as a failure
// reason if applicable.
type TestWindowSummary struct {
	_ struct{} `type:"structure"`

	// If the test failed, the reason why it failed.
	Message *string `type:"string"`

	// The status of the test. Possible status values are:
	//
	//    * ACTIVE
	//
	//    * CREATE_IN_PROGRESS
	//
	//    * CREATE_FAILED
	Status *string `type:"string"`

	// The time at which the test ended.
	TestWindowEnd *time.Time `type:"timestamp"`

	// The time at which the test began.
	TestWindowStart *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TestWindowSummary) String() string {
	return awsutil.Prettify(s)
}

// The weighted loss value for a quantile. This object is part of the Metrics
// object.
type WeightedQuantileLoss struct {
	_ struct{} `type:"structure"`

	// The difference between the predicted value and the actual value over the
	// quantile, weighted (normalized) by dividing by the sum over all quantiles.
	LossValue *float64 `type:"double"`

	// The quantile. Quantiles divide a probability distribution into regions of
	// equal probability. For example, if the distribution was divided into 5 regions
	// of equal probability, the quantiles would be 0.2, 0.4, 0.6, and 0.8.
	Quantile *float64 `type:"double"`
}

// String returns the string representation
func (s WeightedQuantileLoss) String() string {
	return awsutil.Prettify(s)
}

// The metrics for a time range within the evaluation portion of a dataset.
// This object is part of the EvaluationResult object.
//
// The TestWindowStart and TestWindowEnd parameters are determined by the BackTestWindowOffset
// parameter of the EvaluationParameters object.
type WindowSummary struct {
	_ struct{} `type:"structure"`

	// The type of evaluation.
	//
	//    * SUMMARY - The average metrics across all windows.
	//
	//    * COMPUTED - The metrics for the specified window.
	EvaluationType EvaluationType `type:"string" enum:"true"`

	// The number of data points within the window.
	ItemCount *int64 `type:"integer"`

	// Provides metrics used to evaluate the performance of a predictor.
	Metrics *Metrics `type:"structure"`

	// The timestamp that defines the end of the window.
	TestWindowEnd *time.Time `type:"timestamp"`

	// The timestamp that defines the start of the window.
	TestWindowStart *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s WindowSummary) String() string {
	return awsutil.Prettify(s)
}
