// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1000" type:"integer"`

	// The next token from the previous response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDetectorInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1000 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The detector ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The status and description for each detector version.
	DetectorVersionSummaries []DetectorVersionSummary `locationName:"detectorVersionSummaries" type:"list"`

	// The next token to be used for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all versions for a specified detector.
//
//    // Example sending a request using DescribeDetectorRequest.
//    req := client.DescribeDetectorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *Client) DescribeDetectorRequest(input *DescribeDetectorInput) DescribeDetectorRequest {
	op := &aws.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	req := c.newRequest(op, input, &DescribeDetectorOutput{})

	return DescribeDetectorRequest{Request: req, Input: input, Copy: c.DescribeDetectorRequest}
}

// DescribeDetectorRequest is the request type for the
// DescribeDetector API operation.
type DescribeDetectorRequest struct {
	*aws.Request
	Input *DescribeDetectorInput
	Copy  func(*DescribeDetectorInput) DescribeDetectorRequest
}

// Send marshals and sends the DescribeDetector API request.
func (r DescribeDetectorRequest) Send(ctx context.Context) (*DescribeDetectorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDetectorResponse{
		DescribeDetectorOutput: r.Request.Data.(*DescribeDetectorOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDetectorResponse is the response type for the
// DescribeDetector API operation.
type DescribeDetectorResponse struct {
	*DescribeDetectorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDetector request.
func (r *DescribeDetectorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
