// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeModelVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" type:"string"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeModelVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeModelVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The model version details.
	ModelVersionDetails []ModelVersionDetail `locationName:"modelVersionDetails" type:"list"`

	// The next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeModelVersions = "DescribeModelVersions"

// DescribeModelVersionsRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all of the model versions for the specified model type or for the specified
// model type and model ID. You can also get details for a single, specified
// model version.
//
//    // Example sending a request using DescribeModelVersionsRequest.
//    req := client.DescribeModelVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *Client) DescribeModelVersionsRequest(input *DescribeModelVersionsInput) DescribeModelVersionsRequest {
	op := &aws.Operation{
		Name:       opDescribeModelVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeModelVersionsInput{}
	}

	req := c.newRequest(op, input, &DescribeModelVersionsOutput{})

	return DescribeModelVersionsRequest{Request: req, Input: input, Copy: c.DescribeModelVersionsRequest}
}

// DescribeModelVersionsRequest is the request type for the
// DescribeModelVersions API operation.
type DescribeModelVersionsRequest struct {
	*aws.Request
	Input *DescribeModelVersionsInput
	Copy  func(*DescribeModelVersionsInput) DescribeModelVersionsRequest
}

// Send marshals and sends the DescribeModelVersions API request.
func (r DescribeModelVersionsRequest) Send(ctx context.Context) (*DescribeModelVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeModelVersionsResponse{
		DescribeModelVersionsOutput: r.Request.Data.(*DescribeModelVersionsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeModelVersionsRequestPaginator returns a paginator for DescribeModelVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeModelVersionsRequest(input)
//   p := frauddetector.NewDescribeModelVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeModelVersionsPaginator(req DescribeModelVersionsRequest) DescribeModelVersionsPaginator {
	return DescribeModelVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeModelVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeModelVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeModelVersionsPaginator struct {
	aws.Pager
}

func (p *DescribeModelVersionsPaginator) CurrentPage() *DescribeModelVersionsOutput {
	return p.Pager.CurrentPage().(*DescribeModelVersionsOutput)
}

// DescribeModelVersionsResponse is the response type for the
// DescribeModelVersions API operation.
type DescribeModelVersionsResponse struct {
	*DescribeModelVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeModelVersions request.
func (r *DescribeModelVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
