// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDetectorsInput"}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// The detectors.
	Detectors []Detector `locationName:"detectors" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDetectors = "GetDetectors"

// GetDetectorsRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all detectors or a single detector if a detectorId is specified. This
// is a paginated API. If you provide a null maxResults, this action retrieves
// a maximum of 10 records per page. If you provide a maxResults, the value
// must be between 5 and 10. To get the next page results, provide the pagination
// token from the GetDetectorsResponse as part of your request. A null pagination
// token fetches the records from the beginning.
//
//    // Example sending a request using GetDetectorsRequest.
//    req := client.GetDetectorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *Client) GetDetectorsRequest(input *GetDetectorsInput) GetDetectorsRequest {
	op := &aws.Operation{
		Name:       opGetDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDetectorsInput{}
	}

	req := c.newRequest(op, input, &GetDetectorsOutput{})

	return GetDetectorsRequest{Request: req, Input: input, Copy: c.GetDetectorsRequest}
}

// GetDetectorsRequest is the request type for the
// GetDetectors API operation.
type GetDetectorsRequest struct {
	*aws.Request
	Input *GetDetectorsInput
	Copy  func(*GetDetectorsInput) GetDetectorsRequest
}

// Send marshals and sends the GetDetectors API request.
func (r GetDetectorsRequest) Send(ctx context.Context) (*GetDetectorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDetectorsResponse{
		GetDetectorsOutput: r.Request.Data.(*GetDetectorsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetDetectorsRequestPaginator returns a paginator for GetDetectors.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetDetectorsRequest(input)
//   p := frauddetector.NewGetDetectorsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetDetectorsPaginator(req GetDetectorsRequest) GetDetectorsPaginator {
	return GetDetectorsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetDetectorsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetDetectorsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetDetectorsPaginator struct {
	aws.Pager
}

func (p *GetDetectorsPaginator) CurrentPage() *GetDetectorsOutput {
	return p.Pager.CurrentPage().(*GetDetectorsOutput)
}

// GetDetectorsResponse is the response type for the
// GetDetectors API operation.
type GetDetectorsResponse struct {
	*GetDetectorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDetectors request.
func (r *GetDetectorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
