// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetLabelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// The name of the label or labels to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLabelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetLabelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 10))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetLabelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of labels.
	Labels []Label `locationName:"labels" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetLabels = "GetLabels"

// GetLabelsRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets all labels or a specific label if name is provided. This is a paginated
// API. If you provide a null maxResults, this action retrieves a maximum of
// 50 records per page. If you provide a maxResults, the value must be between
// 10 and 50. To get the next page results, provide the pagination token from
// the GetGetLabelsResponse as part of your request. A null pagination token
// fetches the records from the beginning.
//
//    // Example sending a request using GetLabelsRequest.
//    req := client.GetLabelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels
func (c *Client) GetLabelsRequest(input *GetLabelsInput) GetLabelsRequest {
	op := &aws.Operation{
		Name:       opGetLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLabelsInput{}
	}

	req := c.newRequest(op, input, &GetLabelsOutput{})

	return GetLabelsRequest{Request: req, Input: input, Copy: c.GetLabelsRequest}
}

// GetLabelsRequest is the request type for the
// GetLabels API operation.
type GetLabelsRequest struct {
	*aws.Request
	Input *GetLabelsInput
	Copy  func(*GetLabelsInput) GetLabelsRequest
}

// Send marshals and sends the GetLabels API request.
func (r GetLabelsRequest) Send(ctx context.Context) (*GetLabelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetLabelsResponse{
		GetLabelsOutput: r.Request.Data.(*GetLabelsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetLabelsRequestPaginator returns a paginator for GetLabels.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetLabelsRequest(input)
//   p := frauddetector.NewGetLabelsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetLabelsPaginator(req GetLabelsRequest) GetLabelsPaginator {
	return GetLabelsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetLabelsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetLabelsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetLabelsPaginator struct {
	aws.Pager
}

func (p *GetLabelsPaginator) CurrentPage() *GetLabelsOutput {
	return p.Pager.CurrentPage().(*GetLabelsOutput)
}

// GetLabelsResponse is the response type for the
// GetLabels API operation.
type GetLabelsResponse struct {
	*GetLabelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetLabels request.
func (r *GetLabelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
