// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetModelVersionInput"}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if s.ModelVersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelVersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model version ARN.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The event details.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The model version number.
	ModelVersionNumber *string `locationName:"modelVersionNumber" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`

	// The training data schema.
	TrainingDataSchema *TrainingDataSchema `locationName:"trainingDataSchema" type:"structure"`

	// The training data source.
	TrainingDataSource TrainingDataSourceEnum `locationName:"trainingDataSource" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetModelVersion = "GetModelVersion"

// GetModelVersionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Gets the details of the specified model version.
//
//    // Example sending a request using GetModelVersionRequest.
//    req := client.GetModelVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *Client) GetModelVersionRequest(input *GetModelVersionInput) GetModelVersionRequest {
	op := &aws.Operation{
		Name:       opGetModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelVersionInput{}
	}

	req := c.newRequest(op, input, &GetModelVersionOutput{})

	return GetModelVersionRequest{Request: req, Input: input, Copy: c.GetModelVersionRequest}
}

// GetModelVersionRequest is the request type for the
// GetModelVersion API operation.
type GetModelVersionRequest struct {
	*aws.Request
	Input *GetModelVersionInput
	Copy  func(*GetModelVersionInput) GetModelVersionRequest
}

// Send marshals and sends the GetModelVersion API request.
func (r GetModelVersionRequest) Send(ctx context.Context) (*GetModelVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetModelVersionResponse{
		GetModelVersionOutput: r.Request.Data.(*GetModelVersionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetModelVersionResponse is the response type for the
// GetModelVersion API operation.
type GetModelVersionResponse struct {
	*GetModelVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetModelVersion request.
func (r *GetModelVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
