// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutKMSEncryptionKeyInput struct {
	_ struct{} `type:"structure"`

	// The KMS encryption key ARN.
	//
	// KmsEncryptionKeyArn is a required field
	KmsEncryptionKeyArn *string `locationName:"kmsEncryptionKeyArn" min:"7" type:"string" required:"true"`
}

// String returns the string representation
func (s PutKMSEncryptionKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKMSEncryptionKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutKMSEncryptionKeyInput"}

	if s.KmsEncryptionKeyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("KmsEncryptionKeyArn"))
	}
	if s.KmsEncryptionKeyArn != nil && len(*s.KmsEncryptionKeyArn) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsEncryptionKeyArn", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutKMSEncryptionKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutKMSEncryptionKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutKMSEncryptionKey = "PutKMSEncryptionKey"

// PutKMSEncryptionKeyRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Specifies the Key Management Service (KMS) customer master key (CMK) to be
// used to encrypt content in Amazon Fraud Detector.
//
//    // Example sending a request using PutKMSEncryptionKeyRequest.
//    req := client.PutKMSEncryptionKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey
func (c *Client) PutKMSEncryptionKeyRequest(input *PutKMSEncryptionKeyInput) PutKMSEncryptionKeyRequest {
	op := &aws.Operation{
		Name:       opPutKMSEncryptionKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKMSEncryptionKeyInput{}
	}

	req := c.newRequest(op, input, &PutKMSEncryptionKeyOutput{})

	return PutKMSEncryptionKeyRequest{Request: req, Input: input, Copy: c.PutKMSEncryptionKeyRequest}
}

// PutKMSEncryptionKeyRequest is the request type for the
// PutKMSEncryptionKey API operation.
type PutKMSEncryptionKeyRequest struct {
	*aws.Request
	Input *PutKMSEncryptionKeyInput
	Copy  func(*PutKMSEncryptionKeyInput) PutKMSEncryptionKeyRequest
}

// Send marshals and sends the PutKMSEncryptionKey API request.
func (r PutKMSEncryptionKeyRequest) Send(ctx context.Context) (*PutKMSEncryptionKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutKMSEncryptionKeyResponse{
		PutKMSEncryptionKeyOutput: r.Request.Data.(*PutKMSEncryptionKeyOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutKMSEncryptionKeyResponse is the response type for the
// PutKMSEncryptionKey API operation.
type PutKMSEncryptionKeyResponse struct {
	*PutKMSEncryptionKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutKMSEncryptionKey request.
func (r *PutKMSEncryptionKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
