// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// The new model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates a model. You can update the description attribute using this action.
//
//    // Example sending a request using UpdateModelRequest.
//    req := client.UpdateModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel
func (c *Client) UpdateModelRequest(input *UpdateModelInput) UpdateModelRequest {
	op := &aws.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	req := c.newRequest(op, input, &UpdateModelOutput{})

	return UpdateModelRequest{Request: req, Input: input, Copy: c.UpdateModelRequest}
}

// UpdateModelRequest is the request type for the
// UpdateModel API operation.
type UpdateModelRequest struct {
	*aws.Request
	Input *UpdateModelInput
	Copy  func(*UpdateModelInput) UpdateModelRequest
}

// Send marshals and sends the UpdateModel API request.
func (r UpdateModelRequest) Send(ctx context.Context) (*UpdateModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateModelResponse{
		UpdateModelOutput: r.Request.Data.(*UpdateModelOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateModelResponse is the response type for the
// UpdateModel API operation.
type UpdateModelResponse struct {
	*UpdateModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateModel request.
func (r *UpdateModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
