// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The event details.
	ExternalEventsDetail *ExternalEventsDetail `locationName:"externalEventsDetail" type:"structure"`

	// The major version number.
	//
	// MajorVersionNumber is a required field
	MajorVersionNumber *string `locationName:"majorVersionNumber" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// A collection of key and value pairs.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s UpdateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateModelVersionInput"}

	if s.MajorVersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("MajorVersionNumber"))
	}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}
	if s.ExternalEventsDetail != nil {
		if err := s.ExternalEventsDetail.Validate(); err != nil {
			invalidParams.AddNested("ExternalEventsDetail", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" enum:"true"`

	// The model version number of the model version updated.
	ModelVersionNumber *string `locationName:"modelVersionNumber" type:"string"`

	// The status of the updated model version.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s UpdateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateModelVersion = "UpdateModelVersion"

// UpdateModelVersionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates a model version. Updating a model version retrains an existing model
// version using updated training data and produces a new minor version of the
// model. You can update the training data set location and data access role
// attributes using this action. This action creates and trains a new minor
// version of the model, for example version 1.01, 1.02, 1.03.
//
//    // Example sending a request using UpdateModelVersionRequest.
//    req := client.UpdateModelVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *Client) UpdateModelVersionRequest(input *UpdateModelVersionInput) UpdateModelVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateModelVersionOutput{})

	return UpdateModelVersionRequest{Request: req, Input: input, Copy: c.UpdateModelVersionRequest}
}

// UpdateModelVersionRequest is the request type for the
// UpdateModelVersion API operation.
type UpdateModelVersionRequest struct {
	*aws.Request
	Input *UpdateModelVersionInput
	Copy  func(*UpdateModelVersionInput) UpdateModelVersionRequest
}

// Send marshals and sends the UpdateModelVersion API request.
func (r UpdateModelVersionRequest) Send(ctx context.Context) (*UpdateModelVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateModelVersionResponse{
		UpdateModelVersionOutput: r.Request.Data.(*UpdateModelVersionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateModelVersionResponse is the response type for the
// UpdateModelVersion API operation.
type UpdateModelVersionResponse struct {
	*UpdateModelVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateModelVersion request.
func (r *UpdateModelVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
