// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateModelVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The model ID of the model version to update.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// The model version number.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" type:"string" required:"true"`

	// The model version status.
	//
	// Status is a required field
	Status ModelVersionStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateModelVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateModelVersionStatusInput"}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if s.ModelVersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelVersionNumber"))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateModelVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateModelVersionStatus = "UpdateModelVersionStatus"

// UpdateModelVersionStatusRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates the status of a model version.
//
// You can perform the following status updates:
//
// Change the TRAINING_COMPLETE status to ACTIVE.
//
// Change ACTIVEto INACTIVE.
//
//    // Example sending a request using UpdateModelVersionStatusRequest.
//    req := client.UpdateModelVersionStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus
func (c *Client) UpdateModelVersionStatusRequest(input *UpdateModelVersionStatusInput) UpdateModelVersionStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateModelVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateModelVersionStatusOutput{})

	return UpdateModelVersionStatusRequest{Request: req, Input: input, Copy: c.UpdateModelVersionStatusRequest}
}

// UpdateModelVersionStatusRequest is the request type for the
// UpdateModelVersionStatus API operation.
type UpdateModelVersionStatusRequest struct {
	*aws.Request
	Input *UpdateModelVersionStatusInput
	Copy  func(*UpdateModelVersionStatusInput) UpdateModelVersionStatusRequest
}

// Send marshals and sends the UpdateModelVersionStatus API request.
func (r UpdateModelVersionStatusRequest) Send(ctx context.Context) (*UpdateModelVersionStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateModelVersionStatusResponse{
		UpdateModelVersionStatusOutput: r.Request.Data.(*UpdateModelVersionStatusOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateModelVersionStatusResponse is the response type for the
// UpdateModelVersionStatus API operation.
type UpdateModelVersionStatusResponse struct {
	*UpdateModelVersionStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateModelVersionStatus request.
func (r *UpdateModelVersionStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
