// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateRuleMetadataInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRuleMetadataInput"}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateRuleMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRuleMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRuleMetadata = "UpdateRuleMetadata"

// UpdateRuleMetadataRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates a rule's metadata. The description attribute can be updated.
//
//    // Example sending a request using UpdateRuleMetadataRequest.
//    req := client.UpdateRuleMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *Client) UpdateRuleMetadataRequest(input *UpdateRuleMetadataInput) UpdateRuleMetadataRequest {
	op := &aws.Operation{
		Name:       opUpdateRuleMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleMetadataInput{}
	}

	req := c.newRequest(op, input, &UpdateRuleMetadataOutput{})

	return UpdateRuleMetadataRequest{Request: req, Input: input, Copy: c.UpdateRuleMetadataRequest}
}

// UpdateRuleMetadataRequest is the request type for the
// UpdateRuleMetadata API operation.
type UpdateRuleMetadataRequest struct {
	*aws.Request
	Input *UpdateRuleMetadataInput
	Copy  func(*UpdateRuleMetadataInput) UpdateRuleMetadataRequest
}

// Send marshals and sends the UpdateRuleMetadata API request.
func (r UpdateRuleMetadataRequest) Send(ctx context.Context) (*UpdateRuleMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRuleMetadataResponse{
		UpdateRuleMetadataOutput: r.Request.Data.(*UpdateRuleMetadataOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRuleMetadataResponse is the response type for the
// UpdateRuleMetadata API operation.
type UpdateRuleMetadataResponse struct {
	*UpdateRuleMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRuleMetadata request.
func (r *UpdateRuleMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
