// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateDataRepositoryTaskInput struct {
	_ struct{} `type:"structure"`

	// (Optional) An idempotency token for resource creation, in a string of up
	// to 64 ASCII characters. This token is automatically filled on your behalf
	// when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// (Optional) The path or paths on the Amazon FSx file system to use when the
	// data repository task is processed. The default path is the file system root
	// directory. The paths you provide need to be relative to the mount point of
	// the file system. If the mount point is /mnt/fsx and /mnt/fsx/path1 is a directory
	// or file on the file system you want to export, then the path to provide is
	// path1. If a path that you provide isn't valid, the task fails.
	Paths []string `type:"list"`

	// Defines whether or not Amazon FSx provides a CompletionReport once the task
	// has completed. A CompletionReport provides a detailed report on the files
	// that Amazon FSx processed that meet the criteria specified by the Scope parameter.
	// For more information, see Working with Task Completion Reports (https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
	//
	// Report is a required field
	Report *CompletionReport `type:"structure" required:"true"`

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag `min:"1" type:"list"`

	// Specifies the type of data repository task to create.
	//
	// Type is a required field
	Type DataRepositoryTaskType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateDataRepositoryTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataRepositoryTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDataRepositoryTaskInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemId", 11))
	}

	if s.Report == nil {
		invalidParams.Add(aws.NewErrParamRequired("Report"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Report != nil {
		if err := s.Report.Validate(); err != nil {
			invalidParams.AddNested("Report", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateDataRepositoryTaskOutput struct {
	_ struct{} `type:"structure"`

	// The description of the data repository task that you just created.
	DataRepositoryTask *DataRepositoryTask `type:"structure"`
}

// String returns the string representation
func (s CreateDataRepositoryTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDataRepositoryTask = "CreateDataRepositoryTask"

// CreateDataRepositoryTaskRequest returns a request value for making API operation for
// Amazon FSx.
//
// Creates an Amazon FSx for Lustre data repository task. You use data repository
// tasks to perform bulk operations between your Amazon FSx file system and
// its linked data repository. An example of a data repository task is exporting
// any data and metadata changes, including POSIX metadata, to files, directories,
// and symbolic links (symlinks) from your FSx file system to its linked data
// repository. A CreateDataRepositoryTask operation will fail if a data repository
// is not linked to the FSx file system. To learn more about data repository
// tasks, see Using Data Repository Tasks (https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html).
// To learn more about linking a data repository to your file system, see Setting
// the Export Prefix (https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repository.html#export-prefix).
//
//    // Example sending a request using CreateDataRepositoryTaskRequest.
//    req := client.CreateDataRepositoryTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateDataRepositoryTask
func (c *Client) CreateDataRepositoryTaskRequest(input *CreateDataRepositoryTaskInput) CreateDataRepositoryTaskRequest {
	op := &aws.Operation{
		Name:       opCreateDataRepositoryTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataRepositoryTaskInput{}
	}

	req := c.newRequest(op, input, &CreateDataRepositoryTaskOutput{})

	return CreateDataRepositoryTaskRequest{Request: req, Input: input, Copy: c.CreateDataRepositoryTaskRequest}
}

// CreateDataRepositoryTaskRequest is the request type for the
// CreateDataRepositoryTask API operation.
type CreateDataRepositoryTaskRequest struct {
	*aws.Request
	Input *CreateDataRepositoryTaskInput
	Copy  func(*CreateDataRepositoryTaskInput) CreateDataRepositoryTaskRequest
}

// Send marshals and sends the CreateDataRepositoryTask API request.
func (r CreateDataRepositoryTaskRequest) Send(ctx context.Context) (*CreateDataRepositoryTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDataRepositoryTaskResponse{
		CreateDataRepositoryTaskOutput: r.Request.Data.(*CreateDataRepositoryTaskOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDataRepositoryTaskResponse is the response type for the
// CreateDataRepositoryTask API operation.
type CreateDataRepositoryTaskResponse struct {
	*CreateDataRepositoryTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDataRepositoryTask request.
func (r *CreateDataRepositoryTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
