// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request object for the UpdateFileSystem operation.
type UpdateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent
	// updates. This string is automatically filled on your behalf when you use
	// the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Identifies the file system that you are updating.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The configuration object for Amazon FSx for Lustre file systems used in the
	// UpdateFileSystem operation.
	LustreConfiguration *UpdateFileSystemLustreConfiguration `type:"structure"`

	// Use this parameter to increase the storage capacity of an Amazon FSx for
	// Windows File Server file system. Specifies the storage capacity target value,
	// GiB, for the file system you're updating. The storage capacity target value
	// must be at least 10 percent (%) greater than the current storage capacity
	// value. In order to increase storage capacity, the file system needs to have
	// at least 16 MB/s of throughput capacity. You cannot make a storage capacity
	// increase request if there is an existing storage capacity increase request
	// in progress. For more information, see Managing Storage Capacity (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html).
	StorageCapacity *int64 `type:"integer"`

	// The configuration updates for an Amazon FSx for Windows File Server file
	// system.
	WindowsConfiguration *UpdateFileSystemWindowsConfiguration `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.LustreConfiguration != nil {
		if err := s.LustreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.WindowsConfiguration != nil {
		if err := s.WindowsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the UpdateFileSystem operation.
type UpdateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// A description of the file system that was updated.
	FileSystem *FileSystem `type:"structure"`
}

// String returns the string representation
func (s UpdateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateFileSystem = "UpdateFileSystem"

// UpdateFileSystemRequest returns a request value for making API operation for
// Amazon FSx.
//
// Use this operation to update the configuration of an existing Amazon FSx
// file system. For an Amazon FSx for Lustre file system, you can update only
// the WeeklyMaintenanceStartTime. For an Amazon for Windows File Server file
// system, you can update the following properties:
//
//    * AutomaticBackupRetentionDays
//
//    * DailyAutomaticBackupStartTime
//
//    * SelfManagedActiveDirectoryConfiguration
//
//    * StorageCapacity
//
//    * ThroughputCapacity
//
//    * WeeklyMaintenanceStartTime
//
// You can update multiple properties in a single request.
//
//    // Example sending a request using UpdateFileSystemRequest.
//    req := client.UpdateFileSystemRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/UpdateFileSystem
func (c *Client) UpdateFileSystemRequest(input *UpdateFileSystemInput) UpdateFileSystemRequest {
	op := &aws.Operation{
		Name:       opUpdateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFileSystemInput{}
	}

	req := c.newRequest(op, input, &UpdateFileSystemOutput{})

	return UpdateFileSystemRequest{Request: req, Input: input, Copy: c.UpdateFileSystemRequest}
}

// UpdateFileSystemRequest is the request type for the
// UpdateFileSystem API operation.
type UpdateFileSystemRequest struct {
	*aws.Request
	Input *UpdateFileSystemInput
	Copy  func(*UpdateFileSystemInput) UpdateFileSystemRequest
}

// Send marshals and sends the UpdateFileSystem API request.
func (r UpdateFileSystemRequest) Send(ctx context.Context) (*UpdateFileSystemResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFileSystemResponse{
		UpdateFileSystemOutput: r.Request.Data.(*UpdateFileSystemOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFileSystemResponse is the response type for the
// UpdateFileSystem API operation.
type UpdateFileSystemResponse struct {
	*UpdateFileSystemOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFileSystem request.
func (r *UpdateFileSystemResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
