// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ClaimGameServerInput struct {
	_ struct{} `type:"structure"`

	// A set of custom game server properties, formatted as a single string value,
	// to be passed to the claimed game server.
	GameServerData *string `min:"1" type:"string"`

	// An identifier for the game server group. When claiming a specific game server,
	// this is the game server group whether the game server is located. When requesting
	// that GameLift FleetIQ locate an available game server, this is the game server
	// group to search on. You can use either the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// A custom string that uniquely identifies the game server to claim. If this
	// parameter is left empty, GameLift FleetIQ searches for an available game
	// server in the specified game server group.
	GameServerId *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ClaimGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClaimGameServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ClaimGameServerInput"}
	if s.GameServerData != nil && len(*s.GameServerData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerData", 1))
	}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ClaimGameServerOutput struct {
	_ struct{} `type:"structure"`

	// Object that describes the newly claimed game server resource.
	GameServer *GameServer `type:"structure"`
}

// String returns the string representation
func (s ClaimGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opClaimGameServer = "ClaimGameServer"

// ClaimGameServerRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Locates an available game server and temporarily reserves it to host gameplay
// and players. This action is called by a game client or client service (such
// as a matchmaker) to request hosting resources for a new game session. In
// response, GameLift FleetIQ searches for an available game server in the specified
// game server group, places the game server in "claimed" status for 60 seconds,
// and returns connection information back to the requester so that players
// can connect to the game server.
//
// There are two ways you can claim a game server. For the first option, you
// provide a game server group ID only, which prompts GameLift FleetIQ to search
// for an available game server in the specified group and claim it. With this
// option, GameLift FleetIQ attempts to consolidate gameplay on as few instances
// as possible to minimize hosting costs. For the second option, you request
// a specific game server by its ID. This option results in a less efficient
// claiming process because it does not take advantage of consolidation and
// may fail if the requested game server is unavailable.
//
// To claim a game server, identify a game server group and (optionally) a game
// server ID. If your game requires that game data be provided to the game server
// at the start of a game, such as a game map or player information, you can
// provide it in your claim request.
//
// When a game server is successfully claimed, connection information is returned.
// A claimed game server's utilization status remains AVAILABLE, while the claim
// status is set to CLAIMED for up to 60 seconds. This time period allows the
// game server to be prompted to update its status to UTILIZED (using UpdateGameServer).
// If the game server's status is not updated within 60 seconds, the game server
// reverts to unclaimed status and is available to be claimed by another request.
//
// If you try to claim a specific game server, this request will fail in the
// following cases: (1) if the game server utilization status is UTILIZED, (2)
// if the game server claim status is CLAIMED, or (3) if the instance that the
// game server is running on is flagged as draining.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * RegisterGameServer
//
//    * ListGameServers
//
//    * ClaimGameServer
//
//    * DescribeGameServer
//
//    * UpdateGameServer
//
//    * DeregisterGameServer
//
//    // Example sending a request using ClaimGameServerRequest.
//    req := client.ClaimGameServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer
func (c *Client) ClaimGameServerRequest(input *ClaimGameServerInput) ClaimGameServerRequest {
	op := &aws.Operation{
		Name:       opClaimGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClaimGameServerInput{}
	}

	req := c.newRequest(op, input, &ClaimGameServerOutput{})

	return ClaimGameServerRequest{Request: req, Input: input, Copy: c.ClaimGameServerRequest}
}

// ClaimGameServerRequest is the request type for the
// ClaimGameServer API operation.
type ClaimGameServerRequest struct {
	*aws.Request
	Input *ClaimGameServerInput
	Copy  func(*ClaimGameServerInput) ClaimGameServerRequest
}

// Send marshals and sends the ClaimGameServer API request.
func (r ClaimGameServerRequest) Send(ctx context.Context) (*ClaimGameServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ClaimGameServerResponse{
		ClaimGameServerOutput: r.Request.Data.(*ClaimGameServerOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ClaimGameServerResponse is the response type for the
// ClaimGameServer API operation.
type ClaimGameServerResponse struct {
	*ClaimGameServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ClaimGameServer request.
func (r *ClaimGameServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
