// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// The type of delete to perform. Options include:
	//
	//    * SAFE_DELETE – Terminates the game server group and EC2 Auto Scaling
	//    group only when it has no game servers that are in IN_USE status.
	//
	//    * FORCE_DELETE – Terminates the game server group, including all active
	//    game servers regardless of their utilization status, and the EC2 Auto
	//    Scaling group.
	//
	//    * RETAIN – Does a safe delete of the game server group but retains the
	//    EC2 Auto Scaling group as is.
	DeleteOption GameServerGroupDeleteOption `type:"string" enum:"true"`

	// The unique identifier of the game server group to delete. Use either the
	// GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGameServerGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteGameServerGroupInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the deleted game server group resource, with status
	// updated to DELETE_SCHEDULED.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation
func (s DeleteGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteGameServerGroup = "DeleteGameServerGroup"

// DeleteGameServerGroupRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Terminates a game server group and permanently deletes the game server group
// record. You have several options for how these resources are impacted when
// deleting the game server group. Depending on the type of delete action selected,
// this action may affect three types of resources: the game server group, the
// corresponding Auto Scaling group, and all game servers currently running
// in the group.
//
// To delete a game server group, identify the game server group to delete and
// specify the type of delete action to initiate. Game server groups can only
// be deleted if they are in ACTIVE or ERROR status.
//
// If the delete request is successful, a series of actions are kicked off.
// The game server group status is changed to DELETE_SCHEDULED, which prevents
// new game servers from being registered and stops autoscaling activity. Once
// all game servers in the game server group are de-registered, GameLift FleetIQ
// can begin deleting resources. If any of the delete actions fail, the game
// server group is placed in ERROR status.
//
// GameLift FleetIQ emits delete events to Amazon CloudWatch.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * CreateGameServerGroup
//
//    * ListGameServerGroups
//
//    * DescribeGameServerGroup
//
//    * UpdateGameServerGroup
//
//    * DeleteGameServerGroup
//
//    * ResumeGameServerGroup
//
//    * SuspendGameServerGroup
//
//    // Example sending a request using DeleteGameServerGroupRequest.
//    req := client.DeleteGameServerGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup
func (c *Client) DeleteGameServerGroupRequest(input *DeleteGameServerGroupInput) DeleteGameServerGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGameServerGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteGameServerGroupOutput{})

	return DeleteGameServerGroupRequest{Request: req, Input: input, Copy: c.DeleteGameServerGroupRequest}
}

// DeleteGameServerGroupRequest is the request type for the
// DeleteGameServerGroup API operation.
type DeleteGameServerGroupRequest struct {
	*aws.Request
	Input *DeleteGameServerGroupInput
	Copy  func(*DeleteGameServerGroupInput) DeleteGameServerGroupRequest
}

// Send marshals and sends the DeleteGameServerGroup API request.
func (r DeleteGameServerGroupRequest) Send(ctx context.Context) (*DeleteGameServerGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteGameServerGroupResponse{
		DeleteGameServerGroupOutput: r.Request.Data.(*DeleteGameServerGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteGameServerGroupResponse is the response type for the
// DeleteGameServerGroup API operation.
type DeleteGameServerGroupResponse struct {
	*DeleteGameServerGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteGameServerGroup request.
func (r *DeleteGameServerGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
