// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeregisterGameServerInput struct {
	_ struct{} `type:"structure"`

	// An identifier for the game server group where the game server to be de-registered
	// is running. Use either the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`

	// The identifier for the game server to be de-registered.
	//
	// GameServerId is a required field
	GameServerId *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterGameServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterGameServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterGameServerInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if s.GameServerId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerId"))
	}
	if s.GameServerId != nil && len(*s.GameServerId) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerId", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterGameServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterGameServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterGameServer = "DeregisterGameServer"

// DeregisterGameServerRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Removes the game server resource from the game server group. As a result
// of this action, the de-registered game server can no longer be claimed and
// will not returned in a list of active game servers.
//
// To de-register a game server, specify the game server group and game server
// ID. If successful, this action emits a CloudWatch event with termination
// time stamp and reason.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * RegisterGameServer
//
//    * ListGameServers
//
//    * ClaimGameServer
//
//    * DescribeGameServer
//
//    * UpdateGameServer
//
//    * DeregisterGameServer
//
//    // Example sending a request using DeregisterGameServerRequest.
//    req := client.DeregisterGameServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer
func (c *Client) DeregisterGameServerRequest(input *DeregisterGameServerInput) DeregisterGameServerRequest {
	op := &aws.Operation{
		Name:       opDeregisterGameServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterGameServerInput{}
	}

	req := c.newRequest(op, input, &DeregisterGameServerOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeregisterGameServerRequest{Request: req, Input: input, Copy: c.DeregisterGameServerRequest}
}

// DeregisterGameServerRequest is the request type for the
// DeregisterGameServer API operation.
type DeregisterGameServerRequest struct {
	*aws.Request
	Input *DeregisterGameServerInput
	Copy  func(*DeregisterGameServerInput) DeregisterGameServerRequest
}

// Send marshals and sends the DeregisterGameServer API request.
func (r DeregisterGameServerRequest) Send(ctx context.Context) (*DeregisterGameServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterGameServerResponse{
		DeregisterGameServerOutput: r.Request.Data.(*DeregisterGameServerOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterGameServerResponse is the response type for the
// DeregisterGameServer API operation.
type DeregisterGameServerResponse struct {
	*DeregisterGameServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterGameServer request.
func (r *DeregisterGameServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
