// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeGameServerGroupInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the game server group being requested. Use either
	// the GameServerGroup name or ARN value.
	//
	// GameServerGroupName is a required field
	GameServerGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGameServerGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGameServerGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGameServerGroupInput"}

	if s.GameServerGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GameServerGroupName"))
	}
	if s.GameServerGroupName != nil && len(*s.GameServerGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GameServerGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeGameServerGroupOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the requested game server group resource.
	GameServerGroup *GameServerGroup `type:"structure"`
}

// String returns the string representation
func (s DescribeGameServerGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeGameServerGroup = "DescribeGameServerGroup"

// DescribeGameServerGroupRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Retrieves information on a game server group.
//
// To get attributes for a game server group, provide a group name or ARN value.
// If successful, a GameServerGroup object is returned.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * CreateGameServerGroup
//
//    * ListGameServerGroups
//
//    * DescribeGameServerGroup
//
//    * UpdateGameServerGroup
//
//    * DeleteGameServerGroup
//
//    * ResumeGameServerGroup
//
//    * SuspendGameServerGroup
//
//    // Example sending a request using DescribeGameServerGroupRequest.
//    req := client.DescribeGameServerGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup
func (c *Client) DescribeGameServerGroupRequest(input *DescribeGameServerGroupInput) DescribeGameServerGroupRequest {
	op := &aws.Operation{
		Name:       opDescribeGameServerGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGameServerGroupInput{}
	}

	req := c.newRequest(op, input, &DescribeGameServerGroupOutput{})

	return DescribeGameServerGroupRequest{Request: req, Input: input, Copy: c.DescribeGameServerGroupRequest}
}

// DescribeGameServerGroupRequest is the request type for the
// DescribeGameServerGroup API operation.
type DescribeGameServerGroupRequest struct {
	*aws.Request
	Input *DescribeGameServerGroupInput
	Copy  func(*DescribeGameServerGroupInput) DescribeGameServerGroupRequest
}

// Send marshals and sends the DescribeGameServerGroup API request.
func (r DescribeGameServerGroupRequest) Send(ctx context.Context) (*DescribeGameServerGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGameServerGroupResponse{
		DescribeGameServerGroupOutput: r.Request.Data.(*DescribeGameServerGroupOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGameServerGroupResponse is the response type for the
// DescribeGameServerGroup API operation.
type DescribeGameServerGroupResponse struct {
	*DescribeGameServerGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGameServerGroup request.
func (r *DescribeGameServerGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
