// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeAcceleratorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the accelerator to describe.
	//
	// AcceleratorArn is a required field
	AcceleratorArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAcceleratorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAcceleratorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeAcceleratorInput"}

	if s.AcceleratorArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AcceleratorArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeAcceleratorOutput struct {
	_ struct{} `type:"structure"`

	// The description of the accelerator.
	Accelerator *Accelerator `type:"structure"`
}

// String returns the string representation
func (s DescribeAcceleratorOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAccelerator = "DescribeAccelerator"

// DescribeAcceleratorRequest returns a request value for making API operation for
// AWS Global Accelerator.
//
// Describe an accelerator. To see an AWS CLI example of describing an accelerator,
// scroll down to Example.
//
//    // Example sending a request using DescribeAcceleratorRequest.
//    req := client.DescribeAcceleratorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator
func (c *Client) DescribeAcceleratorRequest(input *DescribeAcceleratorInput) DescribeAcceleratorRequest {
	op := &aws.Operation{
		Name:       opDescribeAccelerator,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAcceleratorInput{}
	}

	req := c.newRequest(op, input, &DescribeAcceleratorOutput{})

	return DescribeAcceleratorRequest{Request: req, Input: input, Copy: c.DescribeAcceleratorRequest}
}

// DescribeAcceleratorRequest is the request type for the
// DescribeAccelerator API operation.
type DescribeAcceleratorRequest struct {
	*aws.Request
	Input *DescribeAcceleratorInput
	Copy  func(*DescribeAcceleratorInput) DescribeAcceleratorRequest
}

// Send marshals and sends the DescribeAccelerator API request.
func (r DescribeAcceleratorRequest) Send(ctx context.Context) (*DescribeAcceleratorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAcceleratorResponse{
		DescribeAcceleratorOutput: r.Request.Data.(*DescribeAcceleratorOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAcceleratorResponse is the response type for the
// DescribeAccelerator API operation.
type DescribeAcceleratorResponse struct {
	*DescribeAcceleratorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAccelerator request.
func (r *DescribeAcceleratorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
