// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeListenerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the listener to describe.
	//
	// ListenerArn is a required field
	ListenerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeListenerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeListenerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeListenerInput"}

	if s.ListenerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ListenerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeListenerOutput struct {
	_ struct{} `type:"structure"`

	// The description of a listener.
	Listener *Listener `type:"structure"`
}

// String returns the string representation
func (s DescribeListenerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeListener = "DescribeListener"

// DescribeListenerRequest returns a request value for making API operation for
// AWS Global Accelerator.
//
// Describe a listener. To see an AWS CLI example of describing a listener,
// scroll down to Example.
//
//    // Example sending a request using DescribeListenerRequest.
//    req := client.DescribeListenerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener
func (c *Client) DescribeListenerRequest(input *DescribeListenerInput) DescribeListenerRequest {
	op := &aws.Operation{
		Name:       opDescribeListener,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeListenerInput{}
	}

	req := c.newRequest(op, input, &DescribeListenerOutput{})

	return DescribeListenerRequest{Request: req, Input: input, Copy: c.DescribeListenerRequest}
}

// DescribeListenerRequest is the request type for the
// DescribeListener API operation.
type DescribeListenerRequest struct {
	*aws.Request
	Input *DescribeListenerInput
	Copy  func(*DescribeListenerInput) DescribeListenerRequest
}

// Send marshals and sends the DescribeListener API request.
func (r DescribeListenerRequest) Send(ctx context.Context) (*DescribeListenerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeListenerResponse{
		DescribeListenerOutput: r.Request.Data.(*DescribeListenerOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeListenerResponse is the response type for the
// DescribeListener API operation.
type DescribeListenerResponse struct {
	*DescribeListenerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeListener request.
func (r *DescribeListenerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
