// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchDeleteTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is provided,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// A list of the IDs of versions to be deleted. A VersionId is a string representation
	// of an integer. Each version is incremented by 1.
	//
	// VersionIds is a required field
	VersionIds []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchDeleteTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if s.VersionIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchDeleteTableVersionOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered while trying to delete the specified table versions.
	Errors []TableVersionError `type:"list"`
}

// String returns the string representation
func (s BatchDeleteTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchDeleteTableVersion = "BatchDeleteTableVersion"

// BatchDeleteTableVersionRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a specified batch of versions of a table.
//
//    // Example sending a request using BatchDeleteTableVersionRequest.
//    req := client.BatchDeleteTableVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion
func (c *Client) BatchDeleteTableVersionRequest(input *BatchDeleteTableVersionInput) BatchDeleteTableVersionRequest {
	op := &aws.Operation{
		Name:       opBatchDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteTableVersionInput{}
	}

	req := c.newRequest(op, input, &BatchDeleteTableVersionOutput{})

	return BatchDeleteTableVersionRequest{Request: req, Input: input, Copy: c.BatchDeleteTableVersionRequest}
}

// BatchDeleteTableVersionRequest is the request type for the
// BatchDeleteTableVersion API operation.
type BatchDeleteTableVersionRequest struct {
	*aws.Request
	Input *BatchDeleteTableVersionInput
	Copy  func(*BatchDeleteTableVersionInput) BatchDeleteTableVersionRequest
}

// Send marshals and sends the BatchDeleteTableVersion API request.
func (r BatchDeleteTableVersionRequest) Send(ctx context.Context) (*BatchDeleteTableVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchDeleteTableVersionResponse{
		BatchDeleteTableVersionOutput: r.Request.Data.(*BatchDeleteTableVersionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchDeleteTableVersionResponse is the response type for the
// BatchDeleteTableVersion API operation.
type BatchDeleteTableVersionResponse struct {
	*BatchDeleteTableVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchDeleteTableVersion request.
func (r *BatchDeleteTableVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
