// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetTriggersInput struct {
	_ struct{} `type:"structure"`

	// A list of trigger names, which may be the names returned from the ListTriggers
	// operation.
	//
	// TriggerNames is a required field
	TriggerNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTriggersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetTriggersInput"}

	if s.TriggerNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("TriggerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetTriggersOutput struct {
	_ struct{} `type:"structure"`

	// A list of trigger definitions.
	Triggers []Trigger `type:"list"`

	// A list of names of triggers not found.
	TriggersNotFound []string `type:"list"`
}

// String returns the string representation
func (s BatchGetTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetTriggers = "BatchGetTriggers"

// BatchGetTriggersRequest returns a request value for making API operation for
// AWS Glue.
//
// Returns a list of resource metadata for a given list of trigger names. After
// calling the ListTriggers operation, you can call this operation to access
// the data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
//    // Example sending a request using BatchGetTriggersRequest.
//    req := client.BatchGetTriggersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetTriggers
func (c *Client) BatchGetTriggersRequest(input *BatchGetTriggersInput) BatchGetTriggersRequest {
	op := &aws.Operation{
		Name:       opBatchGetTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetTriggersInput{}
	}

	req := c.newRequest(op, input, &BatchGetTriggersOutput{})

	return BatchGetTriggersRequest{Request: req, Input: input, Copy: c.BatchGetTriggersRequest}
}

// BatchGetTriggersRequest is the request type for the
// BatchGetTriggers API operation.
type BatchGetTriggersRequest struct {
	*aws.Request
	Input *BatchGetTriggersInput
	Copy  func(*BatchGetTriggersInput) BatchGetTriggersRequest
}

// Send marshals and sends the BatchGetTriggers API request.
func (r BatchGetTriggersRequest) Send(ctx context.Context) (*BatchGetTriggersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetTriggersResponse{
		BatchGetTriggersOutput: r.Request.Data.(*BatchGetTriggersOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetTriggersResponse is the response type for the
// BatchGetTriggers API operation.
type BatchGetTriggersResponse struct {
	*BatchGetTriggersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetTriggers request.
func (r *BatchGetTriggersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
