// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// This parameter is deprecated. Use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) to allocate to this Job.
	// You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that executes this job.
	//
	// Command is a required field
	Command *JobCommand `type:"structure" required:"true"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string `type:"map"`

	// Description of the job being defined.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// Glue version determines the versions of Apache Spark and Python that AWS
	// Glue supports. The Python version indicates the version supported for jobs
	// of type Spark.
	//
	// For more information about the available AWS Glue versions and corresponding
	// Spark and Python versions, see Glue version (https://docs.aws.amazon.com/glue/latest/dg/add-job.html)
	// in the developer guide.
	//
	// Jobs that are created without specifying a Glue version default to Glue 0.9.
	GlueVersion *string `min:"1" type:"string"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a Python shell job or an Apache Spark ETL job:
	//
	//    * When you specify a Python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job definition. It must be unique in your account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Non-overridable arguments for this job, specified as name-value pairs.
	NonOverridableArguments map[string]string `type:"map"`

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or Amazon Resource Name (ARN) of the IAM role associated with this
	// job.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The tags to use with this job. You may use tags to limit access to the job.
	// For more information about tags in AWS Glue, see AWS Tags in AWS Glue (https://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html)
	// in the developer guide.
	Tags map[string]string `type:"map"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker maps to 1 DPU (4 vCPU, 16 GB of
	//    memory, 64 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	//
	//    * For the G.2X worker type, each worker maps to 2 DPU (8 vCPU, 32 GB of
	//    memory, 128 GB disk), and provides 1 executor per worker. We recommend
	//    this worker type for memory-intensive jobs.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateJobInput"}

	if s.Command == nil {
		invalidParams.Add(aws.NewErrParamRequired("Command"))
	}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Role == nil {
		invalidParams.Add(aws.NewErrParamRequired("Role"))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique name that was provided for this job definition.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateJob = "CreateJob"

// CreateJobRequest returns a request value for making API operation for
// AWS Glue.
//
// Creates a new job definition.
//
//    // Example sending a request using CreateJobRequest.
//    req := client.CreateJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob
func (c *Client) CreateJobRequest(input *CreateJobInput) CreateJobRequest {
	op := &aws.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	req := c.newRequest(op, input, &CreateJobOutput{})

	return CreateJobRequest{Request: req, Input: input, Copy: c.CreateJobRequest}
}

// CreateJobRequest is the request type for the
// CreateJob API operation.
type CreateJobRequest struct {
	*aws.Request
	Input *CreateJobInput
	Copy  func(*CreateJobInput) CreateJobRequest
}

// Send marshals and sends the CreateJob API request.
func (r CreateJobRequest) Send(ctx context.Context) (*CreateJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateJobResponse{
		CreateJobOutput: r.Request.Data.(*CreateJobOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateJobResponse is the response type for the
// CreateJob API operation.
type CreateJobResponse struct {
	*CreateJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateJob request.
func (r *CreateJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
