// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDevEndpointInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDevEndpointInput"}

	if s.EndpointName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteDevEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDevEndpoint = "DeleteDevEndpoint"

// DeleteDevEndpointRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a specified development endpoint.
//
//    // Example sending a request using DeleteDevEndpointRequest.
//    req := client.DeleteDevEndpointRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint
func (c *Client) DeleteDevEndpointRequest(input *DeleteDevEndpointInput) DeleteDevEndpointRequest {
	op := &aws.Operation{
		Name:       opDeleteDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevEndpointInput{}
	}

	req := c.newRequest(op, input, &DeleteDevEndpointOutput{})

	return DeleteDevEndpointRequest{Request: req, Input: input, Copy: c.DeleteDevEndpointRequest}
}

// DeleteDevEndpointRequest is the request type for the
// DeleteDevEndpoint API operation.
type DeleteDevEndpointRequest struct {
	*aws.Request
	Input *DeleteDevEndpointInput
	Copy  func(*DeleteDevEndpointInput) DeleteDevEndpointRequest
}

// Send marshals and sends the DeleteDevEndpoint API request.
func (r DeleteDevEndpointRequest) Send(ctx context.Context) (*DeleteDevEndpointResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDevEndpointResponse{
		DeleteDevEndpointOutput: r.Request.Data.(*DeleteDevEndpointOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDevEndpointResponse is the response type for the
// DeleteDevEndpoint API operation.
type DeleteDevEndpointResponse struct {
	*DeleteDevEndpointOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDevEndpoint request.
func (r *DeleteDevEndpointResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
