// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetColumnStatisticsForPartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of the column names.
	//
	// ColumnNames is a required field
	ColumnNames []string `type:"list" required:"true"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of partition values identifying the partition.
	//
	// PartitionValues is a required field
	PartitionValues []string `type:"list" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetColumnStatisticsForPartitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetColumnStatisticsForPartitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetColumnStatisticsForPartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ColumnNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnNames"))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.PartitionValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("PartitionValues"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetColumnStatisticsForPartitionOutput struct {
	_ struct{} `type:"structure"`

	// List of ColumnStatistics that failed to be retrieved.
	ColumnStatisticsList []ColumnStatistics `type:"list"`

	// Error occurred during retrieving column statistics data.
	Errors []ColumnError `type:"list"`
}

// String returns the string representation
func (s GetColumnStatisticsForPartitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetColumnStatisticsForPartition = "GetColumnStatisticsForPartition"

// GetColumnStatisticsForPartitionRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves partition statistics of columns.
//
//    // Example sending a request using GetColumnStatisticsForPartitionRequest.
//    req := client.GetColumnStatisticsForPartitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForPartition
func (c *Client) GetColumnStatisticsForPartitionRequest(input *GetColumnStatisticsForPartitionInput) GetColumnStatisticsForPartitionRequest {
	op := &aws.Operation{
		Name:       opGetColumnStatisticsForPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetColumnStatisticsForPartitionInput{}
	}

	req := c.newRequest(op, input, &GetColumnStatisticsForPartitionOutput{})

	return GetColumnStatisticsForPartitionRequest{Request: req, Input: input, Copy: c.GetColumnStatisticsForPartitionRequest}
}

// GetColumnStatisticsForPartitionRequest is the request type for the
// GetColumnStatisticsForPartition API operation.
type GetColumnStatisticsForPartitionRequest struct {
	*aws.Request
	Input *GetColumnStatisticsForPartitionInput
	Copy  func(*GetColumnStatisticsForPartitionInput) GetColumnStatisticsForPartitionRequest
}

// Send marshals and sends the GetColumnStatisticsForPartition API request.
func (r GetColumnStatisticsForPartitionRequest) Send(ctx context.Context) (*GetColumnStatisticsForPartitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetColumnStatisticsForPartitionResponse{
		GetColumnStatisticsForPartitionOutput: r.Request.Data.(*GetColumnStatisticsForPartitionOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetColumnStatisticsForPartitionResponse is the response type for the
// GetColumnStatisticsForPartition API operation.
type GetColumnStatisticsForPartitionResponse struct {
	*GetColumnStatisticsForPartitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetColumnStatisticsForPartition request.
func (r *GetColumnStatisticsForPartitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
