// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCrawlersInput struct {
	_ struct{} `type:"structure"`

	// The number of crawlers to return on each call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCrawlersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCrawlersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCrawlersOutput struct {
	_ struct{} `type:"structure"`

	// A list of crawler metadata.
	Crawlers []Crawler `type:"list"`

	// A continuation token, if the returned list has not reached the end of those
	// defined in this customer account.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlersOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCrawlers = "GetCrawlers"

// GetCrawlersRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves metadata for all crawlers defined in the customer account.
//
//    // Example sending a request using GetCrawlersRequest.
//    req := client.GetCrawlersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers
func (c *Client) GetCrawlersRequest(input *GetCrawlersInput) GetCrawlersRequest {
	op := &aws.Operation{
		Name:       opGetCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCrawlersInput{}
	}

	req := c.newRequest(op, input, &GetCrawlersOutput{})

	return GetCrawlersRequest{Request: req, Input: input, Copy: c.GetCrawlersRequest}
}

// GetCrawlersRequest is the request type for the
// GetCrawlers API operation.
type GetCrawlersRequest struct {
	*aws.Request
	Input *GetCrawlersInput
	Copy  func(*GetCrawlersInput) GetCrawlersRequest
}

// Send marshals and sends the GetCrawlers API request.
func (r GetCrawlersRequest) Send(ctx context.Context) (*GetCrawlersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCrawlersResponse{
		GetCrawlersOutput: r.Request.Data.(*GetCrawlersOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetCrawlersRequestPaginator returns a paginator for GetCrawlers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetCrawlersRequest(input)
//   p := glue.NewGetCrawlersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetCrawlersPaginator(req GetCrawlersRequest) GetCrawlersPaginator {
	return GetCrawlersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetCrawlersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetCrawlersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetCrawlersPaginator struct {
	aws.Pager
}

func (p *GetCrawlersPaginator) CurrentPage() *GetCrawlersOutput {
	return p.Pager.CurrentPage().(*GetCrawlersOutput)
}

// GetCrawlersResponse is the response type for the
// GetCrawlers API operation.
type GetCrawlersResponse struct {
	*GetCrawlersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCrawlers request.
func (r *GetCrawlersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
